/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.util.SymbolHash;

public class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;

    public static boolean checkTypeDerivationOk(XSTypeDecl xSTypeDecl, XSTypeDecl xSTypeDecl2, short s) {
        if (xSTypeDecl == SchemaGrammar.fAnyType) {
            return xSTypeDecl == xSTypeDecl2;
        }
        if (xSTypeDecl == SchemaGrammar.fAnySimpleType) {
            return xSTypeDecl2 == SchemaGrammar.fAnyType || xSTypeDecl2 == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDecl.getXSType() == 2) {
            if (xSTypeDecl2.getXSType() == 1) {
                if (xSTypeDecl2 == SchemaGrammar.fAnyType) {
                    xSTypeDecl2 = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDecl, (XSSimpleType)xSTypeDecl2, s);
        }
        return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDecl, xSTypeDecl2, s);
    }

    public static boolean checkSimpleDerivationOk(XSSimpleType xSSimpleType, XSTypeDecl xSTypeDecl, short s) {
        if (xSSimpleType == SchemaGrammar.fAnySimpleType) {
            return xSTypeDecl == SchemaGrammar.fAnyType || xSTypeDecl == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDecl.getXSType() == 1) {
            if (xSTypeDecl == SchemaGrammar.fAnyType) {
                xSTypeDecl = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return XSConstraints.checkSimpleDerivation(xSSimpleType, (XSSimpleType)xSTypeDecl, s);
    }

    public static boolean checkComplexDerivationOk(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDecl xSTypeDecl, short s) {
        if (xSComplexTypeDecl == SchemaGrammar.fAnyType) {
            return xSComplexTypeDecl == xSTypeDecl;
        }
        return XSConstraints.checkComplexDerivation(xSComplexTypeDecl, xSTypeDecl, s);
    }

    private static boolean checkSimpleDerivation(XSSimpleType xSSimpleType, XSSimpleType xSSimpleType2, short s) {
        if (xSSimpleType == xSSimpleType2) {
            return true;
        }
        if ((s & 2) != 0 || (xSSimpleType.getBaseType().getFinalSet() & 2) != 0) {
            return false;
        }
        XSSimpleType xSSimpleType3 = (XSSimpleType)xSSimpleType.getBaseType();
        if (xSSimpleType3 == xSSimpleType2) {
            return true;
        }
        if (xSSimpleType3 != SchemaGrammar.fAnySimpleType && XSConstraints.checkSimpleDerivation(xSSimpleType3, xSSimpleType2, s)) {
            return true;
        }
        if ((xSSimpleType.getVariety() == 2 || xSSimpleType.getVariety() == 3) && xSSimpleType2 == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (xSSimpleType2.getVariety() == 3) {
            XSSimpleType[] xSSimpleTypeArray = ((XSUnionSimpleType)xSSimpleType2).getMemberTypes();
            int n = xSSimpleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                xSSimpleType2 = xSSimpleTypeArray[n2];
                if (XSConstraints.checkSimpleDerivation(xSSimpleType, xSSimpleType2, s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean checkComplexDerivation(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDecl xSTypeDecl, short s) {
        if (xSComplexTypeDecl == xSTypeDecl) {
            return true;
        }
        if ((xSComplexTypeDecl.fDerivedBy & s) != 0) {
            return false;
        }
        XSTypeDecl xSTypeDecl2 = xSComplexTypeDecl.fBaseType;
        if (xSTypeDecl2 == xSTypeDecl) {
            return true;
        }
        if (xSTypeDecl2 == SchemaGrammar.fAnyType || xSTypeDecl2 == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (xSTypeDecl2.getXSType() == 1) {
            return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDecl2, xSTypeDecl, s);
        }
        if (xSTypeDecl2.getXSType() == 2) {
            if (xSTypeDecl.getXSType() == 1) {
                if (xSTypeDecl == SchemaGrammar.fAnyType) {
                    xSTypeDecl = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDecl2, (XSSimpleType)xSTypeDecl, s);
        }
        return false;
    }

    public static Object ElementDefaultValidImmediate(XSTypeDecl xSTypeDecl, Object object, ValidationContext validationContext, ValidatedInfo validatedInfo) {
        Object object2;
        XSSimpleType xSSimpleType = null;
        if (xSTypeDecl.getXSType() == 2) {
            xSSimpleType = (XSSimpleType)xSTypeDecl;
        } else {
            object2 = (XSComplexTypeDecl)xSTypeDecl;
            if (((XSComplexTypeDecl)object2).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)object2).fXSSimpleType;
            } else if (((XSComplexTypeDecl)object2).fContentType == 2) {
                if (!((XSComplexTypeDecl)object2).fParticle.emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        object2 = null;
        if (xSSimpleType != null) {
            try {
                if (object instanceof String) {
                    object2 = xSSimpleType.validate((String)object, validationContext, validatedInfo);
                } else {
                    ValidatedInfo validatedInfo2 = (ValidatedInfo)object;
                    xSSimpleType.validate(validationContext, validatedInfo2);
                    object2 = validatedInfo2.actualValue;
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                return null;
            }
        }
        return object2;
    }

    public static void fullSchemaChecking(XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter) {
        Object object;
        int n;
        Object[] objectArray;
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        int n2 = schemaGrammarArray.length - 1;
        while (n2 >= 0) {
            substitutionGroupHandler.addSubstitutionGroup(schemaGrammarArray[n2].getSubstitutionGroups());
            --n2;
        }
        int n3 = schemaGrammarArray.length - 1;
        while (n3 >= 0) {
            objectArray = schemaGrammarArray[n3].getRedefinedGroupDecls();
            n = 0;
            while (n < objectArray.length) {
                XSGroupDecl xSGroupDecl = objectArray[n++];
                XSParticleDecl xSParticleDecl = xSGroupDecl.fParticle;
                object = objectArray[n++];
                XSParticleDecl xSParticleDecl2 = ((XSGroupDecl)object).fParticle;
                if (xSParticleDecl2 == null) {
                    if (xSParticleDecl == null) continue;
                    xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, "rcase-Recurse.2"}, (short)1);
                    continue;
                }
                try {
                    XSConstraints.particleValidRestriction(substitutionGroupHandler, xSParticleDecl, xSParticleDecl2);
                }
                catch (XMLSchemaException xMLSchemaException) {
                    String string = xMLSchemaException.getKey();
                    xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, xMLSchemaException.getArgs(), (short)1);
                    xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, string}, (short)1);
                }
            }
            --n3;
        }
        object = new SymbolHash();
        int n4 = schemaGrammarArray.length - 1;
        while (n4 >= 0) {
            int n5 = 0;
            boolean bl = schemaGrammarArray[n4].fFullChecked;
            objectArray = schemaGrammarArray[n4].getUncheckedComplexTypeDecls();
            int n6 = objectArray.length - 1;
            while (n6 >= 0) {
                if (!bl && ((XSComplexTypeDecl)objectArray[n6]).fParticle != null) {
                    ((SymbolHash)object).clear();
                    try {
                        XSConstraints.checkElementDeclsConsistent((XSComplexTypeDecl)objectArray[n6], ((XSComplexTypeDecl)objectArray[n6]).fParticle, (SymbolHash)object, substitutionGroupHandler);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", xMLSchemaException.getKey(), xMLSchemaException.getArgs(), (short)1);
                    }
                }
                if (((XSComplexTypeDecl)objectArray[n6]).fBaseType != null && ((XSComplexTypeDecl)objectArray[n6]).fBaseType != SchemaGrammar.fAnyType && ((XSComplexTypeDecl)objectArray[n6]).fDerivedBy == 2 && ((XSComplexTypeDecl)objectArray[n6]).fParticle != null && ((XSComplexTypeDecl)objectArray[n6]).fBaseType instanceof XSComplexTypeDecl && ((XSComplexTypeDecl)((XSComplexTypeDecl)objectArray[n6]).fBaseType).fParticle != null) {
                    try {
                        XSConstraints.particleValidRestriction(substitutionGroupHandler, ((XSComplexTypeDecl)objectArray[n6]).fParticle, ((XSComplexTypeDecl)((XSComplexTypeDecl)objectArray[n6]).fBaseType).fParticle);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", xMLSchemaException.getKey(), xMLSchemaException.getArgs(), (short)1);
                        xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "derivation-ok-restriction.5.3", new Object[]{((XSComplexTypeDecl)objectArray[n6]).fName}, (short)1);
                    }
                }
                XSCMValidator xSCMValidator = ((XSComplexTypeDecl)objectArray[n6]).getContentModel(cMBuilder);
                n = 0;
                if (xSCMValidator != null) {
                    try {
                        n = xSCMValidator.checkUniqueParticleAttribution(substitutionGroupHandler) ? 1 : 0;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", xMLSchemaException.getKey(), xMLSchemaException.getArgs(), (short)1);
                    }
                }
                if (!bl && n != 0) {
                    objectArray[n5++] = objectArray[n6];
                }
                --n6;
            }
            if (!bl) {
                schemaGrammarArray[n4].setUncheckedTypeNum(n5);
                schemaGrammarArray[n4].fFullChecked = true;
            }
            --n4;
        }
    }

    public static void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        short s = xSParticleDecl.fType;
        if (s == 0 || s == 2) {
            return;
        }
        if (s == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            XSConstraints.findElemInTable(xSComplexTypeDecl, xSElementDecl, symbolHash);
            if (xSElementDecl.isGlobal()) {
                XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
                int n = 0;
                while (n < xSElementDeclArray.length) {
                    XSConstraints.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[n], symbolHash);
                    ++n;
                }
            }
            return;
        }
        XSParticleDecl xSParticleDecl2 = (XSParticleDecl)xSParticleDecl.fValue;
        XSConstraints.checkElementDeclsConsistent(xSComplexTypeDecl, xSParticleDecl2, symbolHash, substitutionGroupHandler);
        XSParticleDecl xSParticleDecl3 = (XSParticleDecl)xSParticleDecl.fOtherValue;
        if (xSParticleDecl3 != null) {
            XSConstraints.checkElementDeclsConsistent(xSComplexTypeDecl, xSParticleDecl3, symbolHash, substitutionGroupHandler);
        }
    }

    public static void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        String string = xSElementDecl.fName + "," + xSElementDecl.fTargetNamespace;
        XSElementDecl xSElementDecl2 = null;
        xSElementDecl2 = (XSElementDecl)symbolHash.get(string);
        if (xSElementDecl2 == null) {
            symbolHash.put(string, (Object)xSElementDecl);
        } else {
            if (xSElementDecl == xSElementDecl2) {
                return;
            }
            if (xSElementDecl.fType != xSElementDecl2.fType) {
                throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, string});
            }
        }
    }

    public static void particleValidRestriction(SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl, XSParticleDecl xSParticleDecl2) throws XMLSchemaException {
        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler);
    }

    private static void particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSElementDeclArray, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        XSElementDecl[] xSElementDeclArray2;
        XSElementDecl xSElementDecl;
        int n;
        int n2;
        XSElementDecl[] xSElementDeclArray3;
        XSElementDecl xSElementDecl2;
        Vector<XSParticleDecl> vector = null;
        Vector vector2 = null;
        int n3 = -2;
        int n4 = -2;
        if (xSParticleDecl.isEmpty() != xSElementDeclArray.isEmpty()) {
            throw new XMLSchemaException("cos-particle-restrict", null);
        }
        int n5 = xSParticleDecl.fType;
        if (n5 == 4 || n5 == 3 || n5 == 5) {
            XSParticleDecl xSParticleDecl2 = XSConstraints.getNonUnaryGroup(xSParticleDecl);
            if (xSParticleDecl2 != xSParticleDecl) {
                xSParticleDecl = xSParticleDecl2;
                n5 = xSParticleDecl.fType;
            }
            vector = XSConstraints.removePointlessChildren(xSParticleDecl);
        }
        int n6 = xSParticleDecl.fMinOccurs;
        int n7 = xSParticleDecl.fMaxOccurs;
        if (substitutionGroupHandler != null && n5 == 1 && (xSElementDecl2 = (XSElementDecl)xSParticleDecl.fValue).isGlobal() && (xSElementDeclArray3 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl2)).length > 0) {
            n5 = 3;
            n6 = xSParticleDecl.fMinOccurs;
            n7 = xSParticleDecl.fMaxOccurs;
            n3 = n6;
            n4 = n7;
            vector = new Vector(xSElementDeclArray3.length + 1);
            n2 = 0;
            while (n2 < xSElementDeclArray3.length) {
                XSConstraints.addElementToParticleVector(vector, xSElementDeclArray3[n2]);
                ++n2;
            }
            XSConstraints.addElementToParticleVector(vector, xSElementDecl2);
            substitutionGroupHandler = null;
        }
        if ((n = xSElementDeclArray.fType) == 4 || n == 3 || n == 5) {
            xSElementDeclArray3 = XSConstraints.getNonUnaryGroup((XSParticleDecl)xSElementDeclArray);
            if (xSElementDeclArray3 != xSElementDeclArray) {
                xSElementDeclArray = xSElementDeclArray3;
                n = xSElementDeclArray.fType;
            }
            vector2 = XSConstraints.removePointlessChildren((XSParticleDecl)xSElementDeclArray);
        }
        int n8 = xSElementDeclArray.fMinOccurs;
        n2 = xSElementDeclArray.fMaxOccurs;
        if (substitutionGroupHandler2 != null && n == 1 && (xSElementDecl = (XSElementDecl)xSElementDeclArray.fValue).isGlobal() && (xSElementDeclArray2 = substitutionGroupHandler2.getSubstitutionGroup(xSElementDecl)).length > 0) {
            n = 3;
            n8 = xSElementDeclArray.fMinOccurs;
            n2 = xSElementDeclArray.fMaxOccurs;
            vector2 = new Vector(xSElementDeclArray2.length + 1);
            int n9 = 0;
            while (n9 < xSElementDeclArray2.length) {
                XSConstraints.addElementToParticleVector(vector2, xSElementDeclArray2[n9]);
                ++n9;
            }
            XSConstraints.addElementToParticleVector(vector2, xSElementDecl);
            substitutionGroupHandler2 = null;
        }
        switch (n5) {
            case 1: {
                switch (n) {
                    case 1: {
                        XSConstraints.checkNameAndTypeOK((XSElementDecl)xSParticleDecl.fValue, n6, n7, (XSElementDecl)xSElementDeclArray.fValue, n8, n2);
                        return;
                    }
                    case 2: {
                        XSConstraints.checkNSCompat((XSElementDecl)xSParticleDecl.fValue, n6, n7, (XSWildcardDecl)xSElementDeclArray.fValue, n8, n2);
                        return;
                    }
                    case 3: {
                        vector = new Vector<XSParticleDecl>();
                        vector.addElement(xSParticleDecl);
                        XSConstraints.checkRecurseLax(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 4: 
                    case 5: {
                        vector = new Vector();
                        vector.addElement(xSParticleDecl);
                        XSConstraints.checkRecurse(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 2: {
                switch (n) {
                    case 2: {
                        XSConstraints.checkNSSubset((XSWildcardDecl)xSParticleDecl.fValue, n6, n7, (XSWildcardDecl)xSElementDeclArray.fValue, n8, n2);
                        return;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 5: {
                switch (n) {
                    case 2: {
                        if (n3 != -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 != -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2);
                        return;
                    }
                    case 5: {
                        XSConstraints.checkRecurse(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 3: {
                switch (n) {
                    case 2: {
                        if (n3 != -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 != -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2);
                        return;
                    }
                    case 3: {
                        XSConstraints.checkRecurseLax(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 4: {
                switch (n) {
                    case 2: {
                        if (n3 != -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 != -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2);
                        return;
                    }
                    case 5: {
                        XSConstraints.checkRecurseUnordered(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 4: {
                        XSConstraints.checkRecurse(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 3: {
                        int n10 = n6 * vector.size();
                        int n11 = n7 == -1 ? n7 : n7 * vector.size();
                        XSConstraints.checkMapAndSum(vector, n10, n11, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return;
                    }
                    case 1: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
        }
    }

    private static void addElementToParticleVector(Vector vector, XSElementDecl xSElementDecl) {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fValue = xSElementDecl;
        xSParticleDecl.fType = 1;
        vector.addElement(xSParticleDecl);
    }

    private static XSParticleDecl getNonUnaryGroup(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2) {
            return xSParticleDecl;
        }
        if (xSParticleDecl.fMinOccurs == 1 && xSParticleDecl.fMaxOccurs == 1 && xSParticleDecl.fValue != null && xSParticleDecl.fOtherValue == null) {
            return XSConstraints.getNonUnaryGroup((XSParticleDecl)xSParticleDecl.fValue);
        }
        return xSParticleDecl;
    }

    private static Vector removePointlessChildren(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2 || xSParticleDecl.fType == 0) {
            return null;
        }
        Vector vector = new Vector();
        XSConstraints.gatherChildren(xSParticleDecl.fType, (XSParticleDecl)xSParticleDecl.fValue, vector);
        if (xSParticleDecl.fOtherValue != null) {
            XSConstraints.gatherChildren(xSParticleDecl.fType, (XSParticleDecl)xSParticleDecl.fOtherValue, vector);
        }
        return vector;
    }

    private static void gatherChildren(int n, XSParticleDecl xSParticleDecl, Vector vector) {
        int n2 = xSParticleDecl.fMinOccurs;
        int n3 = xSParticleDecl.fMaxOccurs;
        short s = xSParticleDecl.fType;
        if (s == 0) {
            return;
        }
        if (s == 1 || s == 2) {
            vector.addElement(xSParticleDecl);
            return;
        }
        XSParticleDecl xSParticleDecl2 = (XSParticleDecl)xSParticleDecl.fValue;
        XSParticleDecl xSParticleDecl3 = (XSParticleDecl)xSParticleDecl.fOtherValue;
        if (n2 != 1 || n3 != 1) {
            vector.addElement(xSParticleDecl);
        } else if (n == s) {
            XSConstraints.gatherChildren(s, xSParticleDecl2, vector);
            if (xSParticleDecl3 != null) {
                XSConstraints.gatherChildren(s, xSParticleDecl3, vector);
            }
        } else if (!xSParticleDecl.isEmpty()) {
            vector.addElement(xSParticleDecl);
        }
    }

    private static void checkNameAndTypeOK(XSElementDecl xSElementDecl, int n, int n2, XSElementDecl xSElementDecl2, int n3, int n4) throws XMLSchemaException {
        if (xSElementDecl.fName != xSElementDecl2.fName || xSElementDecl.fTargetNamespace != xSElementDecl2.fTargetNamespace) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace, xSElementDecl2.fName, xSElementDecl2.fTargetNamespace});
        }
        if (!xSElementDecl2.isNillable() && xSElementDecl.isNillable()) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{xSElementDecl.fName});
        }
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{xSElementDecl.fName});
        }
        if (xSElementDecl2.getConstraintType() == 2) {
            if (xSElementDecl.getConstraintType() != 2) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
            }
            XSSimpleType xSSimpleType = null;
            if (xSElementDecl.fType.getXSType() == 2) {
                xSSimpleType = (XSSimpleType)xSElementDecl.fType;
            } else if (((XSComplexTypeDecl)xSElementDecl.fType).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)xSElementDecl.fType).fXSSimpleType;
            }
            if (xSSimpleType == null && !xSElementDecl2.fDefault.normalizedValue.equals(xSElementDecl.fDefault.normalizedValue) || xSSimpleType != null && !xSSimpleType.isEqual(xSElementDecl2.fDefault.actualValue, xSElementDecl.fDefault.actualValue)) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
            }
        }
        XSConstraints.checkIDConstraintRestriction(xSElementDecl, xSElementDecl2);
        short s = xSElementDecl.fBlock;
        short s2 = xSElementDecl2.fBlock;
        if ((s & s2) != s2 || s == 0 && s2 != 0) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{xSElementDecl.fName});
        }
        if (!XSConstraints.checkTypeDerivationOk(xSElementDecl.fType, xSElementDecl2.fType, (short)13)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{xSElementDecl.fName});
        }
    }

    private static void checkIDConstraintRestriction(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) throws XMLSchemaException {
    }

    private static boolean checkOccurrenceRange(int n, int n2, int n3, int n4) {
        return n >= n3 && (n4 == -1 || n2 != -1 && n2 <= n4);
    }

    private static void checkNSCompat(XSElementDecl xSElementDecl, int n, int n2, XSWildcardDecl xSWildcardDecl, int n3, int n4) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{xSElementDecl.fName});
        }
        if (!xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace});
        }
    }

    private static void checkNSSubset(XSWildcardDecl xSWildcardDecl, int n, int n2, XSWildcardDecl xSWildcardDecl2, int n3, int n4) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSSubset.2", null);
        }
        if (!xSWildcardDecl.isSubsetOf(xSWildcardDecl2)) {
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
    }

    private static void checkNSRecurseCheckCardinality(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl, int n3, int n4) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", null);
        }
        int n5 = vector.size();
        try {
            int n6 = 0;
            while (n6 < n5) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector.elementAt(n6);
                XSConstraints.particleValidRestriction(xSParticleDecl2, substitutionGroupHandler, xSParticleDecl, null);
                ++n6;
            }
        }
        catch (XMLSchemaException xMLSchemaException) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
        }
    }

    private static void checkRecurse(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-Recurse.1", null);
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            block8: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n8);
                int n9 = n7;
                while (n9 < n6) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n9);
                    ++n7;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block8;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        if (!xSParticleDecl2.emptiable()) {
                            throw new XMLSchemaException("rcase-Recurse.2", null);
                        }
                        ++n9;
                    }
                }
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++n8;
        }
        int n10 = n7;
        while (n10 < n6) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector2.elementAt(n10);
            if (!xSParticleDecl.emptiable()) {
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++n10;
        }
    }

    private static void checkRecurseUnordered(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-RecurseUnordered.1", null);
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        boolean[] blArray = new boolean[n6];
        int n7 = 0;
        while (n7 < n5) {
            block8: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n7);
                int n8 = 0;
                while (n8 < n6) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n8);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        if (blArray[n8]) {
                            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                        }
                        blArray[n8] = true;
                        break block8;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n8;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++n7;
        }
        int n9 = 0;
        while (n9 < n6) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector2.elementAt(n9);
            if (!blArray[n9] && !xSParticleDecl.emptiable()) {
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++n9;
        }
    }

    private static void checkRecurseLax(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-RecurseLax.1", null);
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            block5: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n8);
                int n9 = n7;
                while (n9 < n6) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n9);
                    ++n7;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block5;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n9;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseLax.2", null);
            }
            ++n8;
        }
    }

    private static void checkMapAndSum(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-MapAndSum.2", null);
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        int n7 = 0;
        while (n7 < n5) {
            block5: {
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n7);
                int n8 = 0;
                while (n8 < n6) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n8);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        break block5;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        ++n8;
                    }
                }
                throw new XMLSchemaException("rcase-MapAndSum.1", null);
            }
            ++n7;
        }
    }

    public static boolean overlapUPA(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSElementDecl.fName == xSElementDecl2.fName && xSElementDecl.fTargetNamespace == xSElementDecl2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
        int n = xSElementDeclArray.length - 1;
        while (n >= 0) {
            if (xSElementDeclArray[n].fName == xSElementDecl2.fName && xSElementDeclArray[n].fTargetNamespace == xSElementDecl2.fTargetNamespace) {
                return true;
            }
            --n;
        }
        xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl2);
        int n2 = xSElementDeclArray.length - 1;
        while (n2 >= 0) {
            if (xSElementDeclArray[n2].fName == xSElementDecl.fName && xSElementDeclArray[n2].fTargetNamespace == xSElementDecl.fTargetNamespace) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public static boolean overlapUPA(XSElementDecl xSElementDecl, XSWildcardDecl xSWildcardDecl, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
        int n = xSElementDeclArray.length - 1;
        while (n >= 0) {
            if (xSWildcardDecl.allowNamespace(xSElementDeclArray[n].fTargetNamespace)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static boolean overlapUPA(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        XSWildcardDecl xSWildcardDecl3 = xSWildcardDecl.performIntersectionWith(xSWildcardDecl2, xSWildcardDecl.fProcessContents);
        return xSWildcardDecl3 == null || xSWildcardDecl3.fType != 2 || xSWildcardDecl3.fNamespaceList.length != 0;
    }

    public static boolean overlapUPA(Object object, Object object2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (object instanceof XSElementDecl) {
            if (object2 instanceof XSElementDecl) {
                return XSConstraints.overlapUPA((XSElementDecl)object, (XSElementDecl)object2, substitutionGroupHandler);
            }
            return XSConstraints.overlapUPA((XSElementDecl)object, (XSWildcardDecl)object2, substitutionGroupHandler);
        }
        if (object2 instanceof XSElementDecl) {
            return XSConstraints.overlapUPA((XSElementDecl)object2, (XSWildcardDecl)object, substitutionGroupHandler);
        }
        return XSConstraints.overlapUPA((XSWildcardDecl)object, (XSWildcardDecl)object2);
    }
}

