/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler;

import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTrigger;

public class PeriodicTimeTrigger
implements TimeTrigger {
    protected final long m_offset;
    protected final long m_period;
    private long m_triggerTime;

    public PeriodicTimeTrigger(int offset, int period) {
        this.m_offset = offset;
        this.m_period = period;
        this.reset();
    }

    public long getTimeAfter(long moment) {
        if (moment <= this.m_triggerTime) {
            return this.m_triggerTime;
        }
        if (-1L == this.m_period) {
            return -1L;
        }
        long over = moment - this.m_triggerTime;
        long remainder = over % this.m_period;
        return moment + (this.m_period - remainder);
    }

    public long getOffset() {
        return this.m_offset;
    }

    public long getPeriod() {
        return this.m_period;
    }

    public void reset() {
        long current = System.currentTimeMillis();
        this.m_triggerTime = -1L == this.m_offset ? current : current + this.m_offset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PeriodicTimeTrigger[ ");
        sb.append("trigger time=");
        sb.append(this.m_triggerTime);
        sb.append(" ");
        sb.append("offset=");
        sb.append(this.m_offset);
        sb.append(" ");
        if (-1L != this.m_period) {
            sb.append("period=");
            sb.append(this.m_period);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

