/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_ar;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_cz;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_de;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_en;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_fr;
import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class AnalyzeString {
    public static String getAnalyzedString(String content, String className, String separator) throws SDXException {
        if (!content.trim().equals("")) {
            String result = content;
            String sep = separator == null ? "" : separator;
            StringReader str = new StringReader(content);
            StringBuffer strb = new StringBuffer(content.length());
            AbstractAnalyzer _analyzer = null;
            if (className == null || className.equals("")) {
                _analyzer = new Analyzer_fr();
            } else if (className.equals("Analyzer_ar")) {
                _analyzer = new Analyzer_ar();
            } else if (className.equals("Analyzer_br")) {
                System.err.println("L'analyseur Bresilien ne fonctionne pas :-(");
                _analyzer = new DefaultAnalyzer();
            } else if (className.equals("Analyzer_cz")) {
                _analyzer = new Analyzer_cz();
            } else if (className.equals("Analyzer_de")) {
                _analyzer = new Analyzer_de();
            } else if (className.equals("Analyzer_en")) {
                _analyzer = new Analyzer_en();
            } else if (className.equals("Analyzer_fr")) {
                _analyzer = new Analyzer_fr();
            } else if (className.equals("Analyzer_ru")) {
                _analyzer = new Analyzer_ar();
            } else {
                try {
                    Object l_obj = Utilities.getObjectForClassName(null, className, null, className, null);
                    Class<?> l_objClass = l_obj.getClass();
                    if (!(l_obj instanceof Analyzer) || !(l_obj instanceof org.apache.lucene.analysis.Analyzer)) {
                        String[] args = new String[3];
                        args[0] = "Repository";
                        if (l_objClass != null) {
                            args[1] = l_objClass.getName();
                        }
                        args[2] = className;
                        throw new SDXException(null, 10, args, null);
                    }
                    _analyzer = (AbstractAnalyzer)l_obj;
                }
                catch (Exception e) {
                    throw new SDXException("Impossible to use " + className + " as an analyzer.", e);
                }
            }
            if (_analyzer == null) {
                _analyzer = new Analyzer_fr();
            }
            TokenStream tmpTokenStream = _analyzer.tokenStream("dummy", str);
            try {
                Token tmpToken;
                int nb = 0;
                while ((tmpToken = tmpTokenStream.next()) != null) {
                    ++nb;
                    if (tmpToken.termText().trim().equals("")) continue;
                    if (nb != 1) {
                        strb.append(sep);
                    }
                    strb.append(tmpToken.termText());
                }
                result = strb.toString();
            }
            catch (IOException e) {
                System.err.println(e);
                result = "-1";
            }
            return result;
        }
        return "";
    }

    public static String getAnalyzedString(String content) {
        try {
            if (!content.trim().equals("")) {
                return AnalyzeString.getAnalyzedString(content, "Analyzer_fr", null);
            }
            return "";
        }
        catch (SDXException sdxe) {
            return "-1";
        }
    }

    public static String getAnalyzedString(String content, String className) {
        try {
            if (!content.trim().equals("")) {
                return AnalyzeString.getAnalyzedString(content, className, null);
            }
            return "";
        }
        catch (SDXException sdxe) {
            return "-1";
        }
    }
}

