/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIMetadataFormat;
import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.OAIRecord;
import fr.gouv.culture.oai.util.OAIUtilities;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OAIRecordImpl
extends OAIObjectImpl
implements OAIRecord {
    protected String _oaiNamespace = null;
    protected String _identifier = null;
    protected String _datestamp = null;
    protected Vector _setSpecs = new Vector();
    protected boolean _isDeleted = false;
    protected OAIMetadataFormat _oaiMetadataFormat = null;
    protected Source _recordSource = null;
    protected Source _aboutSource = null;

    public void setOAINamspace(String namespace) {
        this._oaiNamespace = namespace;
    }

    public String getOAINamspace() {
        return this._oaiNamespace;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setIdentifier(String identifier) {
        this._identifier = identifier;
    }

    public String getDatestamp() {
        return this._datestamp;
    }

    public void setDatestamp(String datestamp) {
        this._datestamp = datestamp;
    }

    public void setSetSpecs(Vector setSpecs) {
        this._setSpecs = setSpecs;
    }

    public void addSetSpec(String setSpec) {
        this._setSpecs.add(setSpec);
    }

    public Enumeration getSetSpecs() {
        return this._setSpecs.elements();
    }

    public void setIsDeleted(boolean isDeleted) {
        this._isDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public void setMetadataFormat(OAIMetadataFormat format) {
        this._oaiMetadataFormat = format;
    }

    public OAIMetadataFormat getMetaDataFormat() {
        return this._oaiMetadataFormat;
    }

    public void setRecord(Source source) {
        this._recordSource = source;
    }

    public Source getRecord() {
        return this._recordSource;
    }

    public void setAbout(Source source) {
        this._aboutSource = source;
    }

    public Source getAbout() {
        return this._aboutSource;
    }

    public void identifier() throws SAXException {
        super.sendElement(this.getOAINamspace(), "identifier", "identifier", null, this.getIdentifier());
    }

    public void datestamp() throws SAXException {
        super.sendElement(this.getOAINamspace(), "datestamp", "datestamp", null, this.getDatestamp());
    }

    public void setSpecs() throws SAXException {
        super.sendElement(this.getOAINamspace(), "identifier", "identifier", null, this.getIdentifier());
    }

    public void header() throws SAXException {
        String status = null;
        if (this._isDeleted) {
            status = "deleted";
        }
        AttributesImpl atts = new AttributesImpl();
        if (OAIUtilities.checkString(status)) {
            atts.addAttribute("", "status", "status", "CDATA", status);
        }
        super.startElement(this.getOAINamspace(), "header", "header", atts);
        this.identifier();
        this.datestamp();
        this.setSpecs();
        super.endElement(this.getOAINamspace(), "header", "header");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metadata() throws SAXException {
        super.startElement(this.getOAINamspace(), "metadata", "metadata", null);
        try {
            this.sendMetadata();
        }
        finally {
            super.endElement(this.getOAINamspace(), "metadata", "metadata");
        }
    }

    protected void sendMetadata() throws SAXException {
        try {
            SourceUtil.toSAX((Source)this._recordSource, (ContentHandler)((Object)this));
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void about() throws SAXException {
        super.startElement(this.getOAINamspace(), "about", "about", null);
        try {
            SourceUtil.toSAX((Source)this._aboutSource, (ContentHandler)((Object)this));
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        finally {
            super.endElement(this.getOAINamspace(), "about", "about");
        }
    }

    public void record() throws SAXException {
        super.startElement(this.getOAINamspace(), "record", "record", null);
        this.header();
        this.metadata();
        this.about();
        super.endElement(this.getOAINamspace(), "record", "record");
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        ContentHandler origHandler = this.contentHandler;
        super.setContentHandler(contentHandler);
        this.record();
        super.setContentHandler(origHandler);
    }
}

