(define-module (sdom ls)
  #:use-module (srfi srfi-1)
  #:use-module (sdom core)
  #:export     (sdom:serialize
		sdom:serialize-filter))

(sdom:register-feature! "LS" "3.0")

;; Add these options for the parser (which doesn't exist yet, I don't think...)

(sdom:add-dom-config-parameter! "charset-overrides-xml-encoding" #t #f)
(sdom:add-dom-config-parameter! "disallow-doctype" #f #t)
(sdom:add-dom-config-parameter! "ignore-unknown-character-denormalizations"
				#t #f)
(sdom:add-dom-config-parameter! "namespaces" #t #f)
(sdom:add-dom-config-parameter! "resource-resolver" '())
(sdom:add-dom-config-parameter! "supported-media-types-only" #f #t)

;; Add these options for the serializer

(sdom:add-dom-config-parameter! "canonical-form" #f #t)
(sdom:add-dom-config-parameter! "discard-default-content" #t #f)
(sdom:add-dom-config-parameter! "format-pretty-print" #f #t)
(sdom:add-dom-config-parameter! "xml-declaration" #t #f)

(define s-elt 
  (lambda (elt indent f fpp ddc xmld)
    (let ((n (symbol->string (car elt)))
	  (spaces (if fpp (make-string indent #\space) "")))
      (string-append spaces
		     "<" 
		     n
		     (let ((a (sdom:get-dom-property elt 'sdom:attributes))
			   (g (lambda (x) (serialize x 1 f fpp ddc xmld))))
		       (fold string-append "" (map g a)))
		     (let ((c (sdom:get-dom-property elt 'sdom:child-nodes)))
		       (if (not (null? c))
			   (string-append ">" 
					  (string #\nl)
					  (let ((g (lambda (x)
						     (serialize 
						      x (+ 2 indent) f
						      fpp ddc xmld))))
					    (fold string-append "" (map g c)))
					  spaces
					  "</" 
					  n 
					  ">")
			   "/>"))
		     (if fpp (string #\nl) "")))))

(define s-attr
  (lambda (attr indent f fpp ddc xmld)
    (let ((n (symbol->string (cadr attr))))
      (string-append (if fpp (make-string indent #\space) " ")
		     n
		     "=\""
		     (sdom:get-dom-property attr 'sdom:value)
		     "\""))))

(define serialize
  (lambda (n indent f fpp ddc xmld)
    (let ((type (sdom:node-type n)))
      (cond ((eqv? type sdom:node-type-element) 
	     (if (f n) (s-elt n indent f fpp ddc xmld) ""))
	    ((eqv? type sdom:node-type-attr)
	     (if (and (or (not ddc)
			  (sdom:get-dom-property n 'sdom:specified))
		      (f n))
		 (s-attr n indent f fpp ddc xmld) ""))
	    ((eqv? type sdom:node-type-text) 
	     (if (f n) (sdom:get-dom-property n 'sdom:node-value) ""))
	    ((eqv? type sdom:node-type-cdata-section)
	     (if (f n) (sdom:get-dom-property n 'sdom:node-value) ""))
	    ((eqv? type sdom:node-type-entity-reference) 
	     (if (f n) "" ""))
	    ((eqv? type sdom:node-type-entity) 
	     (if (f n) "" ""))
	    ((eqv? type sdom:node-type-processing-instruction) 
	     (if (f n) (string-append (make-string indent #\space)
				      "<?" 
				      (sdom:get-dom-property n 'sdom:target)
				      " "
				      (sdom:get-dom-property n 'sdom:data)
				      "?>"
				      (string #\nl)) ""))
	    ((eqv? type sdom:node-type-comment) 
	     (if (f n) "" ""))
	    ((eqv? type sdom:node-type-document)
	     (if (f n)
		 (s-elt (sdom:get-dom-property n 'sdom:document-element) 
			0
			f 
			fpp 
			ddc
			xmld)
		 ""))
	    ((eqv? type sdom:node-type-document-type) (if (f n) "" ""))
	    ((eqv? type sdom:node-type-document-fragment) (if (f n) "" ""))
	    ((eqv? type sdom:node-type-notation) (if (f n) "" ""))))))

(define sdom:serialize-filter 
  (lambda (node filter . port)
    (let* ((doc (if (not (eqv? (sdom:node-type node) sdom:node-type-document))
		    (sdom:get-dom-property node 'sdom:owner-document)
		    node))
	   (r (serialize 
	       node 0 filter
	       (sdom:get-dom-config-parameter doc "format-pretty-print")
	       (sdom:get-dom-config-parameter doc "discard-default-content")
	       (sdom:get-dom-config-parameter doc "xml-declaration"))))
      (if (null? port) r (display r (car port))))))

(define sdom:serialize
  (lambda (node . port)
    (let ((t (lambda (x) #t)))
      (if (null? port) 
	  (sdom:serialize-filter node t)
	  (sdom:serialize-filter node t (car port))))))