#! /bin/sh
### sdcdc --- sdcdc (some Debian cd's covers) main bin shell script.

## Copyright (C)  2002,2003,2011  Marco Parrone.

## Author: Marco Parrone
## Maintainer: Marco Parrone <marco@marcoparrone.com>
## Keywords: gimp script debian cdrom pixmap
## Language: Shell

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

### Commentary:

## This is part of sdcdc (some Debian CD's covers), a generator for
## Debian CD's labels and front covers.

### Code:

## Configurations.

m4_include(config.m4)

GIMP_FLAGS="$GIMP_FLAGS -i -c -d -s -b"

case $SDCDC_CONF in
    "") SDCDC_CONF="$HOME/.sdcdc.sh"
esac

case $SDCDC_SRC_IMAGE in
    "") SDCDC_SRC_IMAGE="${pkgdatadir}/sdcdc.xcf" ;;
esac

case $SDCDC_MAIN_SCM_SRC in
    "") SDCDC_MAIN_SCM_SRC="${pkgdatadir}/sdcdc.scm" ;;
esac

case $SDCDC_TYPE in
    "") SDCDC_TYPE="" ;;
esac

case $SDCDC_CDN in
    "") SDCDC_CDN="" ;;
esac

case $SDCDC_LANG in
    "") SDCDC_LANG="" ;;
esac

case $SDCDC_ARCH in
    "") SDCDC_ARCH="" ;;
esac

case $SDCDC_SYSTEM in
    "") SDCDC_SYSTEM="" ;;
esac

case $SDCDC_VERS in
    "") SDCDC_VERS="" ;;
esac

case $SDCDC_FILENAME in
    "") SDCDC_FILENAME="" ;;
esac

## Gets the options.

TMP=$(getopt -o hVC:t:c:l:a:s:v:o:S: --long help,version,conf:,type:,cdn:,lang:,arch:,system:,vers:,output:,source-image: -n sdcdc -- ${1+"$@"})

if test $? != 0 ; then
    exit 1
fi

eval set -- "$TMP"

while true ; do
    case "$1" in
	-h|--help)
	echo "sdcdc $VERSION"
	echo
	echo "Purpose:"
	echo "  sdcdc is a generator for Debian CD's labels and front covers."
	echo
	echo "Usage: sdcdc [OPTIONS]"
	echo "   -h           --help                  Print help and exit."
	echo "   -V           --version               Print version and exit."
	echo "   -C FILE      --conf=FILE             Configuration file (optional)."
	echo "   -t STRING    --type=STRING           Image type."
	echo "                                        Valid values are: cd dvd bd"
	echo "                                          cd-fc dvd-fc bd-fc."
	echo "   -c STRING    --cdn=STRING            CD number (from 0 to 99)."
	echo "   -l STRING    --lang=STRING           Language (en or it)."
	echo "   -a STRING    --arch=STRING           Architecture."
	echo "                                        Valid values are: i386 m68k"
	echo "                                          sparc alpha powerpc arm mips"
	echo "                                          mipsel hppa ia64 s390 armel"
	echo "                                          amd64 ppc64 superh armhf"
	echo "                                          m32r avr32."
	echo "   -s STRING    --system=STRING         System."
	echo "                                        Valid values are: GNU/Linux"
	echo "                                          GNU/Hurd GNU/kFreeBSD"
	echo "                                          GNU/NetBSD".
	echo "   -v STRING    --vers=STRING           Version."
	echo "                                        Valid values are: 6.0.0 6.0.1"
	echo "                                          potato woody sarge etch lenny"
	echo "                                          squeeze sid."
	echo "   -o FILE      --output=FILE           Output file name."
	echo "   -S FILE      --source-image=FILE     Source image (optional)."
	echo "   -m FILE      --main-scm-source=FILE  Scheme source file (optional)."
	shift ; exit 0 ;;
	-V|--version)
	echo "sdcdc $VERSION"
	shift ; exit 0 ;;
	-C|--conf)
	SDCDC_CONF=$2
	shift 2 ;;
	-t|--type)
	ARG_SDCDC_TYPE=$2
	shift 2 ;;
	-c|--cdn)
	ARG_SDCDC_CDN=$2
	shift 2 ;;
	-l|--lang)
	ARG_SDCDC_LANG=$2
	shift 2 ;;
	-a|--arch)
	ARG_SDCDC_ARCH=$2
	shift 2 ;;
	-s|--system)
	ARG_SDCDC_SYSTEM=$2
	shift 2 ;;
	-v|--vers)
	ARG_SDCDC_VERS=$2
	shift 2 ;;
	-o|--output)
	ARG_SDCDC_FILENAME=$2
	shift 2 ;;
	-S|--source-image)
	ARG_SDCDC_SRC_IMAGE=$2
	shift 2 ;;
	--) shift ; break ;;
	*) echo "Internal error!" ; exit 1 ;;
    esac
done

## Loads in the configuration file.

if test -f $SDCDC_CONF ; then
    . $SDCDC_CONF
fi

## Sets the command line options.

case $ARG_SDCDC_TYPE in
    "") ;;
    *) SDCDC_TYPE=$ARG_SDCDC_TYPE ;;
esac

case $ARG_SDCDC_CDN in
    "") ;;
    *) SDCDC_CDN=$ARG_SDCDC_CDN ;;
esac

case $ARG_SDCDC_LANG in
    "") ;;
    *) SDCDC_LANG=$ARG_SDCDC_LANG ;;
esac

case $ARG_SDCDC_ARCH in
    "") ;;
    *) SDCDC_ARCH=$ARG_SDCDC_ARCH ;;
esac

case $ARG_SDCDC_SYSTEM in
    "") ;;
    *) SDCDC_SYSTEM=$ARG_SDCDC_SYSTEM ;;
esac

case $ARG_SDCDC_VERS in
    "") ;;
    *) SDCDC_VERS=$ARG_SDCDC_VERS ;;
esac

case $ARG_SDCDC_FILENAME in
    "") ;;
    *) SDCDC_FILENAME=$ARG_SDCDC_FILENAME ;;
esac

case $ARG_SDCDC_SRC_IMAGE in
    "") ;;
    *) SDCDC_SRC_IMAGE=$ARG_SDCDC_SRC_IMAGE ;;
esac

## Checks if the needed informations were given.

case $SDCDC_TYPE in
    "")
    echo "sdcdc: \"--type\" (\"-t\") option required."
    exit 1 ;;
esac

case $SDCDC_CDN in
    "")
    echo "sdcdc: \"--cdn\" (\"-c\") option required."
    exit 1 ;;
esac

case $SDCDC_LANG in
    "")
    echo "sdcdc: \"--lang\" (\"-l\") option required."
    exit 1 ;;
esac

case $SDCDC_ARCH in
    "")
    echo "sdcdc: \"--arch\" (\"-a\") option required."
    exit 1 ;;
esac

case $SDCDC_SYSTEM in
    "")
    echo "sdcdc: \"--system\" (\"-s\") option required."
    exit 1 ;;
esac

case $SDCDC_VERS in
    "")
    echo "sdcdc: \"--vers\" (\"-v\") option required."
    exit 1 ;;
esac

case $SDCDC_FILENAME in
    "")
    echo "sdcdc: \"--output\" (\"-o\") option required."
    exit 1 ;;
esac

## Translates the options so they can be used easily in the scheme
## source files.

case $SDCDC_TYPE in
    "cd") SDCDC_TYPE=1 ;;
    "cd-fc") SDCDC_TYPE=2 ;;
    "dvd") SDCDC_TYPE=3 ;;
    "bd") SDCDC_TYPE=4 ;;
    "dvd-fc") SDCDC_TYPE=5 ;;
    "bd-fc") SDCDC_TYPE=6 ;;
    *)
    echo "sdcdc: wrong \"--type\" (\"-t\") option was given: $SDCDC_TYPE"
    exit 1 ;;
esac

case $SDCDC_CDN in
    0|1|2|3|4|5|6|7|8|9) ;;
    10|11|12|13|14|15|16|17|18|19) ;;
    20|21|22|23|24|25|26|27|28|29) ;;
    30|31|32|33|34|35|36|37|38|39) ;;
    40|41|42|43|44|45|46|47|48|49) ;;
    50|51|52|53|54|55|56|57|58|59) ;;
    60|61|62|63|64|65|66|67|68|69) ;;
    70|71|72|73|74|75|76|77|78|79) ;;
    80|81|82|83|84|85|86|87|88|89) ;;
    90|91|92|93|94|95|96|97|98|99) ;;
    *) "sdcdc: wrong \"--cdn\" (\"-c\") option was given: $SDCDC_TYPE"
    exit 1 ;;
esac

case $SDCDC_LANG in
    "en") SDCDC_LANG=1 ;;
    "it") SDCDC_LANG=2 ;;
    *) echo "sdcdc: wrong \"--lang\" (\"-l\") option was given: $SDCDC_LANG"
    exit 1 ;;
esac

case $SDCDC_ARCH in
    "i386") SDCDC_ARCH=1 ;;
    "m68k") SDCDC_ARCH=2 ;;
    "sparc") SDCDC_ARCH=3 ;;
    "alpha") SDCDC_ARCH=4 ;;
    "powerpc") SDCDC_ARCH=5 ;;
    "arm") SDCDC_ARCH=6 ;;
    "mips") SDCDC_ARCH=7 ;;
    "mipsel") SDCDC_ARCH=8 ;;
    "hppa") SDCDC_ARCH=9 ;;
    "ia64") SDCDC_ARCH=10 ;;
    "s390") SDCDC_ARCH=11 ;;
    "armel") SDCDC_ARCH=12 ;;
    "amd64") SDCDC_ARCH=13 ;;
    "ppc64") SDCDC_ARCH=14 ;;
    "superh") SDCDC_ARCH=15 ;;
    "armhf") SDCDC_ARCH=16 ;;
    "m32r") SDCDC_ARCH=17 ;;
    "avr32") SDCDC_ARCH=18 ;;
    *) echo "sdcdc: wrong \"--arch\" (\"-a\") option was given: $SDCDC_ARCH"
    exit 1 ;;
esac

case $SDCDC_SYSTEM in
    "GNU/Linux") SDCDC_SYSTEM=1 ;;
    "GNU/Hurd") SDCDC_SYSTEM=2 ;;
    "GNU/NetBSD") SDCDC_SYSTEM=3 ;;
    "GNU/kFreeBSD") SDCDC_SYSTEM=4 ;;
    *) echo "sdcdc: wrong \"--system\" (\"-s\") option was given: $SDCDC_SYSTEM"
    exit 1 ;;
esac

case $SDCDC_VERS in
    "6.0.0") SDCDC_VERS=1 ;;
    "6.0.1") SDCDC_VERS=2 ;;
    "potato") SDCDC_VERS=3 ;;
    "woody") SDCDC_VERS=4 ;;
    "sid") SDCDC_VERS=5 ;;
    "sarge") SDCDC_VERS=6 ;;
    "etch") SDCDC_VERS=7 ;;
    "lenny") SDCDC_VERS=8 ;;
    "squeeze") SDCDC_VERS=9 ;;
    *) echo "sdcdc: wrong \"--vers\" (\"-v\") option was given: $SDCDC_VERS"
    exit 1 ;;
esac

## Makes the temporary source file.

SRCFILE=/tmp/sdcdc-tmp-$RANDOM

touch $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot make temporary file $SCRFILE"
    exit 1
fi

chmod 600 $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot change perms of temporary file $SCRFILE"
    exit 1
fi

echo \(load \"$SDCDC_MAIN_SCM_SRC\"\) > $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot write in temporary file $SCRFILE"
    exit 1
fi

echo "(sdcdc-action \"$SDCDC_FILENAME\" \"$SDCDC_SRC_IMAGE\" $SDCDC_TYPE $SDCDC_CDN $SDCDC_LANG $SDCDC_ARCH $SDCDC_SYSTEM $SDCDC_VERS)" >> $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot append in temporary file $SCRFILE"
    exit 1
fi

echo '(gimp-quit 0)' >> $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot append in temporary file $SCRFILE"
    exit 1
fi

## Makes the image.

gimp $GIMP_FLAGS \(load\ \"$SRCFILE\"\)

if test $? != 0 ; then
    echo "sdcdc.sh: cannot make image $SDCDC_FILENAME from script $SRCFILE"
    exit 1
fi

## Removes the temporary source file.

rm $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot remove temporary file $SCRFILE"
    exit 1
fi

#### sdcdc ends here.
