;; -*- Scheme -*-
;;; sdcdc.scm --- Top part common to the other scripts.

;; Copyright (C)  2002,2003  Marco Parrone.

;; Author: Marco Parrone
;; Maintainer: Marco Parrone <marc0@autistici.org>
;; Keywords: gimp script debian cdrom cover
;; Language: Scheme (The GIMP's Script-Fu)

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Commentary:

;; This is a part of sdcdc (some Debian CD's covers), a generator for
;; Debian CD's labels and front covers.

;;; Code:

;; This function returns the visibility of the given layer (layer-name)
;; in a list of pairs of layers-names and visibility values.
;; It returns 0 if the layer is invisible, 1 if it is visible,
;; nil if it does not exists.
(define get-visibility
  (lambda (layer-name active-layers-map)
    (cadr (member layer-name active-layers-map))))

;; This function is used only by set-layers-visibility,
;; and pratically is part of it.
(define set-layers-visibility-helper
  (lambda (layers active-layers-map clayer)
    (if (= (get-visibility	
	    (car (gimp-layer-get-name (+ clayer 2))) active-layers-map)
	   1)
	(gimp-layer-set-visible
	 (+ clayer 2)
	 (get-visibility
	  (car (gimp-layer-get-name (+ clayer 2))) active-layers-map)))
    (if (< clayer (- (car layers) 1))
	(set-layers-visibility-helper layers active-layers-map (+ clayer 1)))))

;; Sets the visibility of the layers in "layers" according
;; to the map of visible layers "active-layers-map".
(define set-layers-visibility
  (lambda (layers active-layers-map)
    (set-layers-visibility-helper layers active-layers-map 0)))

;; The map of the visible layers.
(define active-layers-map '("CD Background" 0
			    "Front-cover background" 0
			    "Logo" 1
			    "Web site" 1
			    "System gnu-linux" 0
			    "System gnu-hurd" 0
			    "System gnu-netbsd" 0
			    "System gnu-freebsd" 0
			    "Version 3.0r0" 0
			    "Version 3.0r1" 0
			    "Version potato" 0
			    "Version woody" 0
			    "Version sid" 0
			    "Version label [en]" 0
			    "Version label [it]" 0
			    "Architecture [i386-en]" 0
			    "Architecture [m68k-en]" 0
			    "Architecture [sparc-en]" 0
			    "Architecture [alpha-en]" 0
			    "Architecture [powerpc-en]" 0
			    "Architecture [arm-en]" 0
			    "Architecture [mips-en]" 0
			    "Architecture [mipsel-en]" 0
			    "Architecture [hppa-en]" 0
			    "Architecture [ia64-en]" 0
			    "Architecture [s390-en]" 0
			    "Architecture [i386-it]" 0
			    "Architecture [m68k-it]" 0
			    "Architecture [sparc-it]" 0
			    "Architecture [alpha-it]" 0
			    "Architecture [powerpc-it]" 0
			    "Architecture [arm-it]" 0
			    "Architecture [mips-it]" 0
			    "Architecture [mipsel-it]" 0
			    "Architecture [hppa-it]" 0
			    "Architecture [ia64-it]" 0
			    "Architecture [s390-it]" 0
			    "Common CD number [en]" 0
			    "Common CD number [it]" 0
			    "CD 1" 0
			    "CD 2" 0
			    "CD 3" 0
			    "CD 4" 0
			    "CD 5" 0
			    "CD 6" 0
			    "CD 7" 0
			    "Swirl" 1))

;; Sets the background (that for the CDs or that for the front covers.
(define sdcdc-set-helper-cd-or-fc
  (lambda (cd-or-fc)
    (if (= cd-or-fc 1)
	(set-car! (cdr (member "CD Background" active-layers-map)) 1))
    (if (= cd-or-fc 2)
	(set-car!
	 (cdr (member "Front-cover background" active-layers-map)) 1))))

;; Sets the system.
(define sdcdc-set-helper-system
  (lambda (system)
    (if (= system 1)
	(set-car! (cdr (member "System gnu-linux" active-layers-map)) 1))
    (if (= system 2)
	(set-car! (cdr (member "System gnu-hurd" active-layers-map)) 1))
    (if (= system 3)
	(set-car! (cdr (member "System gnu-netbsd" active-layers-map)) 1))
    (if (= system 4)
	(set-car! (cdr (member "System gnu-freebsd" active-layers-map)) 1))))

;; Sets the version.
(define sdcdc-set-helper-vers
  (lambda (vers)
    (if (= vers 1)
	(set-car! (cdr (member "Version 3.0r0" active-layers-map)) 1))
    (if (= vers 2)
	(set-car! (cdr (member "Version 3.0r1" active-layers-map)) 1))
    (if (= vers 3)
	(set-car! (cdr (member "Version potato" active-layers-map)) 1))
    (if (= vers 4)
	(set-car! (cdr (member "Version woody" active-layers-map)) 1))
    (if (= vers 5)
	(set-car! (cdr (member "Version sid" active-layers-map)) 1))))

;; Sets the CD number.
(define sdcdc-set-helper-cd-number
  (lambda (cd-number)
    (if (= cd-number 1) (set-car! (cdr (member "CD 1" active-layers-map)) 1))
    (if (= cd-number 2) (set-car! (cdr (member "CD 2" active-layers-map)) 1))
    (if (= cd-number 3) (set-car! (cdr (member "CD 3" active-layers-map)) 1))
    (if (= cd-number 4) (set-car! (cdr (member "CD 4" active-layers-map)) 1))
    (if (= cd-number 5) (set-car! (cdr (member "CD 5" active-layers-map)) 1))
    (if (= cd-number 6) (set-car! (cdr (member "CD 6" active-layers-map)) 1))
    (if (= cd-number 7) (set-car! (cdr (member "CD 7" active-layers-map)) 1))))

;; Sets the common CD number.
(define sdcdc-set-helper-common-cd-number
  (lambda (lang)
    (if (= lang 1)
	(set-car! (cdr (member "Common CD number [en]" active-layers-map)) 1))
    (if (= lang 2)
	(set-car!
	 (cdr (member "Common CD number [it]" active-layers-map)) 1))))

;; Sets the version label.
(define sdcdc-set-helper-version-label
  (lambda (lang)
    (if (= lang 1)
	(set-car! (cdr (member "Version label [en]" active-layers-map)) 1))
    (if (= lang 2)
	(set-car! (cdr (member "Version label [it]" active-layers-map)) 1))))

;; Sets the arch (1st part).
(define sdcdc-set-helper-arch-1
  (lambda (arch lang)
    (if (and (= lang 1) (= arch 1))
	    (set-car!
	     (cdr (member "Architecture [i386-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 2))
	    (set-car!
	     (cdr (member "Architecture [m68k-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 3))
	    (set-car!
	     (cdr (member "Architecture [sparc-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 4))
	    (set-car!
	     (cdr (member "Architecture [alpha-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 5))
	    (set-car!
	     (cdr (member "Architecture [powerpc-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 6))
	    (set-car!
	     (cdr (member "Architecture [arm-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 7))
	    (set-car!
	     (cdr (member "Architecture [mips-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 8))
	    (set-car!
	     (cdr (member "Architecture [mipsel-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 9))
	    (set-car!
	     (cdr (member "Architecture [hppa-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 10))
	    (set-car!
	     (cdr (member "Architecture [ia64-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 11))
	    (set-car!
	     (cdr (member "Architecture [s390-en]" active-layers-map)) 1))))

;; Sets the arch (2nd part).
(define sdcdc-set-helper-arch-2
  (lambda (arch lang)
    (if (and (= lang 2) (= arch 1))
	(set-car! (cdr (member "Architecture [i386-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 2))
	(set-car! (cdr (member "Architecture [m68k-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 3))
	(set-car!
	 (cdr (member "Architecture [sparc-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 4))
	(set-car!
	 (cdr (member "Architecture [alpha-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 5))
	(set-car!
	 (cdr (member "Architecture [powerpc-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 6))
	(set-car! (cdr (member "Architecture [arm-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 7))
	(set-car! (cdr (member "Architecture [mips-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 8))
	(set-car!
	 (cdr (member "Architecture [mipsel-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 9))
	(set-car! (cdr (member "Architecture [hppa-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 10))
	(set-car! (cdr (member "Architecture [ia64-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 11))
	(set-car!
	 (cdr (member "Architecture [s390-it]" active-layers-map)) 1))))

;; This selects the layers to make visible.
;; This is to be changed when new layers are added.
(define sdcdc-set
  (lambda (cd-or-fc cd-number lang arch system vers)
    (sdcdc-set-helper-cd-or-fc cd-or-fc)
    (sdcdc-set-helper-system system)
    (sdcdc-set-helper-vers vers)
    (sdcdc-set-helper-cd-number cd-number)
    (sdcdc-set-helper-common-cd-number lang)
    (sdcdc-set-helper-version-label lang)
    (sdcdc-set-helper-arch-1 arch lang)
    (sdcdc-set-helper-arch-2 arch lang)))

;; The output file.
(define outfile '())

;; The current image.
(define cimage '())

;; The layers.
(define layers '())

;; Current drawable.
(define cdrawable '())

;; Does the work (selects the layers, flats the image, saves
;; the output image.
(define sdcdc-action
  (lambda (filename src-image cd-or-fc cd-number lang arch system vers)
    (set! outfile filename)
    (set! cimage (gimp-xcf-load 1 src-image src-image))
    (set! layers (gimp-image-get-layers (car cimage)))
    (sdcdc-set cd-or-fc cd-number lang arch system vers)
    (set-layers-visibility layers active-layers-map)
    (set! cdrawable (gimp-image-flatten (car cimage)))
    (file-jpeg-save 1 (car cimage) (car cdrawable)
		    outfile outfile 0.80 0.80 1 1 "Made with The GIMP." 0 0 0 1)))

;;; sdcdc.scm ends here.
