#! /bin/sh
### sdcdc --- sdcdc (some Debian cd's covers) main bin shell script.

## Copyright (C)  2002,2003  Marco Parrone.

## Author: Marco Parrone
## Maintainer: Marco Parrone <marc0@autistici.org>
## Keywords: gimp script debian cdrom pixmap
## Language: Shell

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

### Commentary:

## This is part of sdcdc (some Debian CD's covers), a generator for
## Debian CD's labels and front covers.

### Code:

## Configurations.

m4_include(config.m4)

GIMP_FLAGS="$GIMP_FLAGS -i -c -d -s -b"

case $SDCDC_CONF in
    "") SDCDC_CONF="$HOME/.sdcdc.sh"
esac

case $SDCDC_SRC_IMAGE in
    "") SDCDC_SRC_IMAGE="${pkgdatadir}/sdcdc.xcf" ;;
esac

case $SDCDC_MAIN_SCM_SRC in
    "") SDCDC_MAIN_SCM_SRC="${pkgdatadir}/sdcdc.scm" ;;
esac

case $SDCDC_TYPE in
    "") SDCDC_TYPE="" ;;
esac

case $SDCDC_CDN in
    "") SDCDC_CDN="" ;;
esac

case $SDCDC_LANG in
    "") SDCDC_LANG="" ;;
esac

case $SDCDC_ARCH in
    "") SDCDC_ARCH="" ;;
esac

case $SDCDC_SYSTEM in
    "") SDCDC_SYSTEM="" ;;
esac

case $SDCDC_VERS in
    "") SDCDC_VERS="" ;;
esac

case $SDCDC_FILENAME in
    "") SDCDC_FILENAME="" ;;
esac

## Gets the options.

TMP=$(getopt -o hVC:t:c:l:a:s:v:o:S: --long help,version,conf:,type:,cdn:,lang:,arch:,system:,vers:,output:,source-image: -n sdcdc -- ${1+"$@"})

if test $? != 0 ; then
    exit 1
fi

eval set -- "$TMP"

while true ; do
    case "$1" in
	-h|--help)
	echo "sdcdc $VERSION"
	echo
	echo "Purpose:"
	echo "  sdcdc is a generator for Debian CD's labels and front covers."
	echo
	echo "Usage: sdcdc [OPTIONS]"
	echo "   -h           --help                  Print help and exit"
	echo "   -V           --version               Print version and exit"
	echo "   -C FILE      --conf=FILE             Set the configuration file name"
	echo "   -t STRING    --type=STRING           Image type"
	echo "   -c STRING    --cdn=STRING            CD number"
	echo "   -l STRING    --lang=STRING           Language"
	echo "   -a STRING    --arch=STRING           Architecture"
	echo "   -s STRING    --system=STRING         System"
	echo "   -v STRING    --vers=STRING           Version"
	echo "   -o FILE      --output=FILE           Output file name"
	echo "   -S FILE      --source-image=FILE     Specify the source image"
	echo "   -m FILE      --main-scm-source=FILE  The main scheme source file"
	shift ; exit 0 ;;
	-V|--version)
	echo "sdcdc $VERSION"
	shift ; exit 0 ;;
	-C|--conf)
	SDCDC_CONF=$2
	shift 2 ;;
	-t|--type)
	ARG_SDCDC_TYPE=$2
	shift 2 ;;
	-c|--cdn)
	ARG_SDCDC_CDN=$2
	shift 2 ;;
	-l|--lang)
	ARG_SDCDC_LANG=$2
	shift 2 ;;
	-a|--arch)
	ARG_SDCDC_ARCH=$2
	shift 2 ;;
	-s|--system)
	ARG_SDCDC_SYSTEM=$2
	shift 2 ;;
	-v|--vers)
	ARG_SDCDC_VERS=$2
	shift 2 ;;
	-o|--output)
	ARG_SDCDC_FILENAME=$2
	shift 2 ;;
	-S|--source-image)
	ARG_SDCDC_SRC_IMAGE=$2
	shift 2 ;;
	--) shift ; break ;;
	*) echo "Internal error!" ; exit 1 ;;
    esac
done

## Loads in the configuration file.

if test -f $SDCDC_CONF ; then
    . $SDCDC_CONF
fi

## Sets the command line options.

case $ARG_SDCDC_TYPE in
    "") ;;
    *) SDCDC_TYPE=$ARG_SDCDC_TYPE ;;
esac

case $ARG_SDCDC_CDN in
    "") ;;
    *) SDCDC_CDN=$ARG_SDCDC_CDN ;;
esac

case $ARG_SDCDC_LANG in
    "") ;;
    *) SDCDC_LANG=$ARG_SDCDC_LANG ;;
esac

case $ARG_SDCDC_ARCH in
    "") ;;
    *) SDCDC_ARCH=$ARG_SDCDC_ARCH ;;
esac

case $ARG_SDCDC_SYSTEM in
    "") ;;
    *) SDCDC_SYSTEM=$ARG_SDCDC_SYSTEM ;;
esac

case $ARG_SDCDC_VERS in
    "") ;;
    *) SDCDC_VERS=$ARG_SDCDC_VERS ;;
esac

case $ARG_SDCDC_FILENAME in
    "") ;;
    *) SDCDC_FILENAME=$ARG_SDCDC_FILENAME ;;
esac

case $ARG_SDCDC_SRC_IMAGE in
    "") ;;
    *) SDCDC_SRC_IMAGE=$ARG_SDCDC_SRC_IMAGE ;;
esac

## Checks if the needed informations were given.

case $SDCDC_TYPE in
    "")
    echo "sdcdc: \"--type\" (\"-t\") option required."
    exit 1 ;;
esac

case $SDCDC_CDN in
    "")
    echo "sdcdc: \"--cdn\" (\"-c\") option required."
    exit 1 ;;
esac

case $SDCDC_LANG in
    "")
    echo "sdcdc: \"--lang\" (\"-l\") option required."
    exit 1 ;;
esac

case $SDCDC_ARCH in
    "")
    echo "sdcdc: \"--arch\" (\"-a\") option required."
    exit 1 ;;
esac

case $SDCDC_SYSTEM in
    "")
    echo "sdcdc: \"--system\" (\"-s\") option required."
    exit 1 ;;
esac

case $SDCDC_VERS in
    "")
    echo "sdcdc: \"--vers\" (\"-v\") option required."
    exit 1 ;;
esac

case $SDCDC_FILENAME in
    "")
    echo "sdcdc: \"--output\" (\"-o\") option required."
    exit 1 ;;
esac

## Translates the options so they can be used easily in the scheme
## source files.

case $SDCDC_TYPE in
    "cd") SDCDC_TYPE=1 ;;
    "fc") SDCDC_TYPE=2 ;;
    *)
    echo "sdcdc: wrong "--type" ("-t") option was given: $SDCDC_TYPE"
    exit 1 ;;
esac

case $SDCDC_CDN in
    1|2|3|4|5|6|7) ;;
    *) "sdcdc: wrong "--cdn" ("-c") option was given: $SDCDC_TYPE"
    exit 1 ;;
esac

case $SDCDC_LANG in
    "en") SDCDC_LANG=1 ;;
    "it") SDCDC_LANG=2 ;;
    *) echo "sdcdc: wrong "--lang" ("-l") option was given: $SDCDC_LANG"
    exit 1 ;;
esac

case $SDCDC_ARCH in
    "i386") SDCDC_ARCH=1 ;;
    "m68k") SDCDC_ARCH=2 ;;
    "sparc") SDCDC_ARCH=3 ;;
    "alpha") SDCDC_ARCH=4 ;;
    "powerpc") SDCDC_ARCH=5 ;;
    "arm") SDCDC_ARCH=6 ;;
    "mips") SDCDC_ARCH=7 ;;
    "mipsel") SDCDC_ARCH=8 ;;
    "hppa") SDCDC_ARCH=9 ;;
    "ia64") SDCDC_ARCH=10 ;;
    "s390") SDCDC_ARCH=11 ;;
    *) echo "sdcdc: wrong "--arch" ("-a") option was given: $SDCDC_ARCH"
    exit 1 ;;
esac

case $SDCDC_SYSTEM in
    "GNU/Linux") SDCDC_SYSTEM=1 ;;
    "GNU/Hurd") SDCDC_SYSTEM=2 ;;
    "GNU/NetBSD") SDCDC_SYSTEM=3 ;;
    "GNU/FreeBSD") SDCDC_SYSTEM=4 ;;
    *) echo "sdcdc: wrong "--system" ("-s") option was given: $SDCDC_SYSTEM"
    exit 1 ;;
esac

case $SDCDC_VERS in
    "3.0r0") SDCDC_VERS=1 ;;
    "3.0r1") SDCDC_VERS=2 ;;
    "potato") SDCDC_VERS=3 ;;
    "woody") SDCDC_VERS=4 ;;
    "sid") SDCDC_VERS=5 ;;
    *) echo "sdcdc: wrong "--vers" ("-v") option was given: $SDCDC_VERS"
    exit 1 ;;
esac

## Makes the temporary source file.

SRCFILE=/tmp/sdcdc-tmp-$RANDOM

touch $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot make temporary file $SCRFILE"
    exit 1
fi

chmod 600 $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot change perms of temporary file $SCRFILE"
    exit 1
fi

echo \(load \"$SDCDC_MAIN_SCM_SRC\"\) > $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot write in temporary file $SCRFILE"
    exit 1
fi

echo "(sdcdc-action \"$SDCDC_FILENAME\" \"$SDCDC_SRC_IMAGE\" $SDCDC_TYPE $SDCDC_CDN $SDCDC_LANG $SDCDC_ARCH $SDCDC_SYSTEM $SDCDC_VERS)" >> $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot append in temporary file $SCRFILE"
    exit 1
fi

## Makes the image.

gimp $GIMP_FLAGS \(load\ \"$SRCFILE\"\) '(gimp-quit 0)'

if test $? != 0 ; then
    echo "sdcdc.sh: cannot make image $SDCDC_FILENAME from script $SRCFILE"
    exit 1
fi

## Removes the temporary source file.

rm $SRCFILE

if test $? != 0 ; then
    echo "sdcdc.sh: cannot remove temporary file $SCRFILE"
    exit 1
fi

#### sdcdc ends here.
