;; selection-tests.scm: Test suite for SCSS value selection
;; Copyright (C) 2011 Julian Graham

;; SCSS is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

#!r6rs

(import (rnrs) (scss scss))

(define test-interface
  (let ((attr-fn 
	 (lambda (lst attr)
	   (let* ((attr-sym (string->symbol attr))
		  (attr-pair (find (lambda (x) (eq? (car x) attr-sym)) 
				   (cdar lst))))
	     (and attr-pair (cdr attr-pair))))))
    (scss:make-document-interface
     (lambda (lst) (symbol->string (caar lst)))
     (lambda (lst) (if (null? (cdr lst)) #f (cdr lst)))
     (lambda (lst) #f)
     attr-fn
     (lambda (lst) (attr-fn lst "class"))
     
     #f)))

(define (selection->declaration match) 
  (cons (scss:selected-value-property match) 
	(scss:selected-value-value match)))

(define (test cascade selector-symbol reference-vals)
  (define context 
    (scss:make-selection-context 
     test-interface (scss:make-rendering-interface #f #f) cascade))
  (let ((vals (map selection->declaration
		   (scss:select-values context selector-symbol))))
    (if (equal? vals reference-vals)
	(display #t)
	(begin 
	  (display selector-symbol) 
	  (display " => ") 
	  (display reference-vals) (display ": ")
	  (display "#f ") 
	  (display vals))))
  (newline))

(test (scss:make-cascade 
       #f #f '(css (p (color "red")) 
		   (p (border-color "red")) 
		   (p (border "medium solid")) 
		   (p (color "green"))))
      '((p))
      '((color . "green") 
	(border . "medium solid") 
	(border-color . "red") 
	(color . "red")))

(test (scss:make-cascade
       #f #f '(css ((.one .two .three) (color "green"))))
      '((p (class . "three")))
      '((color . "green")))

(test (scss:make-cascade
       #f #f '(css (p (! (color "green"))) (p (color "red"))))
      '((p))
      '((color . "green") (color . "red")))

(test (scss:make-cascade
       #f #f '(css (p (! (color "green"))) ((p (id "id1")) (color "red"))))
      '((p (id . "id1")))
      '((color . "green") (color . "red")))
