#!/bin/bash
#     Copyright (C) 2005, 2006 Stewart Adam
#    This file is part of audio-convert-mod.

#    audio-convert-mod is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWaudio-convert-mod is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWaudio-convert-mod; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# The uninstall script for audio-convert-mod
# v3.42

# Run this script as root if not already. Jim's fix:
chk_root () {
	if [ ! $( id -u ) -eq 0 ]; then
		wd="$(pwd)"
		echo "Please enter root's password."
		exec su - -c "cd '$wd';${0} ${CMDLN_ARGS}" # Call this prog as root
		exit ${?}  # since we're 'execing' above, we wont reach this exit
		# unless something goes wrong.
	  fi
}
# Call this function early on - now or before your script's main loop starts.  
chk_root

ROOT_UID=0   # Root has $UID 0.
if [ "$UID" -eq "$ROOT_UID" ];then
	rm -rf "/etc/skel/.gnome2/nautilus-scripts/audio-convert-mod"
	rm -f "/usr/local/bin/audio-convert-mod"
	rm -f "/usr/local/bin/audio-convert-mod-userinstall"
	rm -f "/usr/local/bin/remove-converted-endings"
	echo "System uninstall complete. To remove your user installation, please remove the"
	echo "audio-convert-mod folder located in ~/.gnome2/nautilus-scripts ."

else
	echo "Please run this script as root."
fi
