#! /usr/bin/python
#     Copyright (C) 2005, 2006 Stewart Adam
#    This file is part of FWBackups.

#    FWBackups is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWBackups is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWBackups; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
import os
import sys
from shvar import shvarFile
import shutil
from functions import *
import commands

def execute(cmd):
    rescmd = commands.getstatusoutput(cmd)
    if int(rescmd[0]) != 0:
        print rescmd[0]
        print 'An error occurred during backup run. Please check the /root/FWBackups_err.log file for more information.'
        cmd2 = 'echo -e "Command run:\n' + cmd + '\nError:\n' + rescmd[1] + '" >> /root/FWBackups_err.log'
        rescmd2 = commands.getstatusoutput(cmd2)
        error = 1
        
cmd = 'rm -rf /root/FWBackups_err.log'
rescmd = commands.getstatusoutput(cmd)

global config
config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'paths.conf']), True)
trigger = config['path1']
list = 1
global li
li = [1]
global error
error = 0

config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
var = str(config['dirent'])
cmd = 'mkdir -p "' + var + '/Backups/Linux-Old"'
rescmd = commands.getstatusoutput(cmd)
cmd = 'rsync --delete -lrpEogh "' + var + '/Backups/Linux"/* "' + var + '/Backups/Linux-Old"'
execute(cmd)
cmd = 'mkdir -p "' + var + '/Backups/Linux"'
execute(cmd)
var2 = str(config['destent'])
cmd = 'mount ' + var2
rescmd = commands.getstatusoutput(cmd)
cmd = 'mount /'
rescmd = commands.getstatusoutput(cmd)
cmd = 'mount /boot'
rescmd = commands.getstatusoutput(cmd)
var2 = str(config['driveent'])
cmd = 'mount ' + var2
rescmd = commands.getstatusoutput(cmd)
cmd = 'tar -cf ' + var + '/Backups/Linux/etc.tar /etc/'
execute(cmd)
cmd = 'rpm -qa > ' + var + '/Backups/Linux/RPMS.txt'
execute(cmd)
cmd = "rpm -qa --queryformat '%{NAME} ' > " + var + "/Backups/Linux/RPMS_clone.txt"
execute(cmd)
cmd = '/sbin/fdisk -l > ' + var +'/Backups/Linux/fdisk\ -l.txt'
execute(cmd)

while trigger != None:
    #copy for each path
    config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
    var = str(config['dirent'])
    cmd = 'mkdir -p "' + var + '/Backups/Linux' + trigger + '"'
    execute(cmd)
    cmd = 'rsync -lrpEogh --delete "' + trigger + '"/* "' + var + '/Backups/Linux' + trigger + '"'
    execute(cmd)
    #set + after
    config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'paths.conf']), True)
    list = list + 1
    var = "path" + "%s" % list
    li.append(list)
    trigger = config[var]
li = li[:-1]
