#! /usr/bin/python
#     Copyright (c) 2005, 2006 Stewart Adam
#    This file is part of FWBackups.

#    FWBackups is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWBackups is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWBackups; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
import os
import sys
import pygtk
pygtk.require('2.0')
import gtk, gobject
from shvar import shvarFile
import shutil
from functions import *
import commands

class prog:

    def aboutwin(self, widget, event, data=None):
        window2 = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window2.set_title("About FWBackups")
        window2.connect("delete_event", lambda w,e: window2.destroy())
        window2.set_size_request(500, 300)
        icon = window2.render_icon(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_BUTTON)
        window2.set_icon(icon)
        window2.add
        vbox = gtk.VBox(True, 0)
        label1 = gtk.Label("FWBackups created by Firewing1.")
        config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
        label2 = gtk.Label("FWBackups version " + str(config['version']))
        label3 = gtk.Label("See www.nongnu.org/script-wing for updates and information.")
        label4 = gtk.Label("This program is licensed under the GPL Public license.")
        label5 = gtk.Label("(c) 2005 Stewart Adam")
        sep = gtk.HSeparator()
        label6 = gtk.Label("Thank you for choosing FWBackups.")
        close = gtk.Button("Close")
        def destroy_event(widget, event, data=None):
            window2.destroy()
        window2.add(vbox)
        close.connect("clicked", destroy_event, "button.close")
        vbox.pack_start(label1, False, False, 0)
        vbox.pack_start(label2, False, False, 0)
        vbox.pack_start(label3, False, False, 0)
        vbox.pack_start(label4, False, False, 0)
        vbox.pack_start(label5, False, False, 0)
        vbox.pack_start(sep, False, False, 0)
        vbox.pack_start(label6, False, False, 0)
        vbox.pack_start(close, False, False, 0)
        label1.show()
        label2.show()
        label3.show()
        label4.show()
        label5.show()
        label6.show()
        sep.show()
        close.show()
        vbox.show()
        window2.show()
    
    def delete_event(self, widget, event, data=None):
        gtk.main_quit()
        return False
    
    def __init__(self):
        def viewhelp(widget, event, data=None):
            cmd = "htmlview /usr/share/FWBackups/help.html"
            rescmd = commands.getstatusoutput(cmd)
        
        def askYesNo(self, question, default=False):
            dialog = gtk.MessageDialog(parent=window,
                                   flags=gtk.DIALOG_MODAL,
                                   type=gtk.MESSAGE_QUESTION,
                                   buttons=gtk.BUTTONS_YES_NO,
                                   message_format=question)
            dialog.set_transient_for(window)
            dialog.set_default_response(default and gtk.RESPONSE_YES
                                             or gtk.RESPONSE_NO)
            response = dialog.run()
            dialog.destroy()
            if response == gtk.RESPONSE_YES:
                return True
            elif response == gtk.RESPONSE_NO:
                return False
            else:
                return default
        def ask_save(widget, event, data=False):
            if askYesNo(self, 'Save before quitting?', True):
                saveall(None, None)
                self.delete_event(None, None, None)
            else:
                self.delete_event(None, None, None)
            
        def saveconfig(widget, event, data=None):
            config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
            var = dirent.get_text()
            config["dirent"] = var
            var = driveent.get_text()
            config["driveent"] = var
            var = destent.get_text()
            config["destent"] = var
            var = adjustment.get_value()
            var = int(var)
            var = "%s" % var
            config["time"] = var
            var = int(var)
            var = var + 1
            var = str(var)
            statlbl1.set_text("Cronjob set to run " + var + " hours into the day, every day.\n"
                              "(Save configuration to update this value.)\n"
                              "Note that it will not run if the computer is turned off at that time.")
            config.write()
            var = 'Saved preferences to /etc/FWBackups.conf.d/config.conf file.'
            message_id = statusbar.push(context_id, var)

        def readpaths(self):
            configpath = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'paths.conf']), True)
            trigger = configpath['path1']
            list = 1
            global li
            li = [1]
            global pathlist
            pathlist = [gtk.Entry(max=0)]
            while trigger != None:
                pathlist.append(gtk.Entry(max=0))
                pathlist[list].set_text(trigger)
                pathlist[list].show()
                vbox2.pack_start(pathlist[list], True, True, 0)
                
                list = list + 1
                var = "path" + "%s" % list
                li.append(list)
                trigger = configpath[var]
        
        def savepaths(widget, event, data=None):
            paths = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'paths.conf']), True)
            trigger = 0
            elem = 1
            global temp
            temp = ['']
            
            sub = 0
            while trigger != 1:
                temp.append(elem)
                elem2 = elem - sub
                var = "path" + "%s" % elem2
                try:
                    temp[elem] = pathlist[elem].get_text()
                except IndexError:
                    temp[elem] = None
                    trigger = 1
                    break
                else:
                    temp[elem] = pathlist[elem].get_text()
                if temp[elem] == "":
                    paths[var] = pathlist[elem].get_text()
                    sub = sub + 1
                    var2 = var
                    elem2 = elem + sub
                    var = "path" + "%s" % elem2
                    paths[var] = ""
                    var = var2
                else:
                    paths[var] = temp[elem]
                elem = elem + 1
            paths.write()
            var = 'Saved preferences to /etc/FWBackups.conf.d/paths.conf file.'
            message_id = statusbar.push(context_id, var)
            
            
        def savecrontab(widget, event, data=None):
            config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
            var = config["time"]
            rescmd = commands.getstatusoutput('cat /etc/crontab | grep -v "/etc/cron.backup"')
            cmd = "echo -e '" + rescmd[1] + "' > /etc/crontab"
            rescmd = commands.getstatusoutput(cmd)
            cmd = "echo -e '01 " + var + " * * * root run-parts /etc/cron.backup' >> /etc/crontab"
            rescmd = commands.getstatusoutput(cmd)
            rescmd = commands.getstatusoutput('cat /etc/crontab')
            var = 'Saved changes to /etc/crontab file.'
            message_id = statusbar.push(context_id, var)
            
        def saveall(widget, event, data=None):
            saveconfig(None, None)
            savepaths(None, None)
            savecrontab(None, None)
            var = 'Saved all preferences.'
            message_id = statusbar.push(context_id, var)
            
        #window defaults
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_title("FWBackups")
        window.connect("delete_event", lambda w,e: ask_save(None, None))
        window.set_size_request(555, 400)
        icon = window.render_icon(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_BUTTON)
        window.set_icon(icon)
        #window contents
        
        #boxes rdy
        vbox = gtk.VBox(False, 0)
        vbox0 = gtk.VBox(False, 0)
        vbox1 = gtk.VBox(False, 0)
        vbox2 = gtk.VBox(False, 0)
        vbox3 = gtk.VBox(False, 0)
        hbox2 = gtk.HBox(False, 0)
        
        #menubar, to hold menu        
        menubar = gtk.MenuBar()
        #create menu
        filemenu = gtk.Menu()
        helpmenu = gtk.Menu()
        #create sub-menus
        file = gtk.MenuItem("File")
        help = gtk.MenuItem("Help")
        #menu items
        file_open = gtk.ImageMenuItem("Open Backup Paths File")
        img = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_MENU)
        file_open.set_image(img)
        
        file_saveconfig = gtk.ImageMenuItem("Save Configuration")
        img = gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_MENU)
        file_saveconfig.set_image(img)
        file_savepaths = gtk.ImageMenuItem("Save Backup Paths")
        img = gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_MENU)
        file_savepaths.set_image(img)
        file_savecrontab = gtk.ImageMenuItem("Save Changes to Crontab")
        img = gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_MENU)
        file_savecrontab.set_image(img)
        file_saveall = gtk.ImageMenuItem("Save All")
        img = gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_MENU)
        file_saveall.set_image(img)
        file_quit = gtk.ImageMenuItem(gtk.STOCK_QUIT, "Quit")
        
        help_help = gtk.ImageMenuItem(gtk.STOCK_HELP, "Help")
        help_about = gtk.ImageMenuItem(gtk.STOCK_ABOUT, "About")
        # append them
        filemenu.append(file_open)
        filemenu.append(file_saveconfig)
        filemenu.append(file_savepaths)
        filemenu.append(file_savecrontab)
        filemenu.append(file_saveall)
        filemenu.append(file_quit)
        
        helpmenu.append(help_help)
        helpmenu.append(help_about)
        #make submenus to menu
        file.set_submenu(filemenu)
        help.set_submenu(helpmenu)
        #make submenus attach to the menubar
        menubar.append(file)
        menubar.append(help)
        
        #table
        table = gtk.Table(2, 4, False)
        #labels + entries + add to list
        dirlabel = gtk.Label("\nIncluding a trailing slash in not needed.\n\nEnter path to send backups to:\n(Example: /media/Backups)\n")
        dirent = gtk.Entry(max=0)
        
        drivelabel = gtk.Label("Enter drive on which the backup files are to reside:\n(Example: /dev/sda5)\n")
        driveent = gtk.Entry(max=0)
        
        destlabel = gtk.Label("Enter drive on which the original files reside:\n(Example: /dev/hdb3)\n")
        destent = gtk.Entry(max=0)
        label = gtk.Label("\nTo remove an entry, simply leave it blank and save. On restart the entry will be deleted.")
        label.set_pattern(' __ ______ __ ______ ______ _____ __ _____ ___ _____ __ _______ ___ _____ ____ __ ________')
        sep = gtk.HSeparator()
        sep.show()
        label.show()
        vbox2.pack_start(label, False, False, 0)
        vbox2.pack_start(sep, False, False, 0)
        
        add = gtk.Button()
        add_hbox = gtk.HBox(False, 0)
        img = gtk.image_new_from_stock(gtk.STOCK_ADD, gtk.ICON_SIZE_BUTTON) 
        add_hbox.pack_start(img)
        label = gtk.Label("Add")
        add_hbox.pack_start(label)
        add.add(add_hbox)
        addent = gtk.Entry(max=0)
        hbox2.pack_start(addent, True, True, 0)
        hbox2.pack_start(add, False, False, 0)
        vbox2.pack_start(hbox2, False, False, 0)
        
        def add_event(widget, event, data=None):
            new = addent.get_text()
            add.hide()
            addent.hide()
            list = li[-1]
            li.append(list + 1)
            pathlist.append(gtk.Entry(max=0))
            pathlist[list].set_text(new)
            pathlist[list].show()
            vbox2.pack_start(pathlist[list], False, False, 0)
            add.show()
            addent.show()
            addent.set_text('')
        
        add.connect("clicked", add_event, "button.add")
        readpaths(self)
        
        #statusbar, set text, ruler...
        hseparator = gtk.HSeparator()
        statusbar = gtk.Statusbar()
        context_id = statusbar.get_context_id('FWBackups')
        config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
        message_id = statusbar.push(context_id, 'FWBackups ' + str(config['version']) + ' loaded sucessfully.')
        def timeout(data):
            statusbar.remove(context_id, message_id)
            return True
        timed_obj = gobject.timeout_add(5000, timeout, "timeout")
        
        # What happens?
        file_quit.connect("activate", ask_save, "menu.file_quit")
        help_about.connect("activate", self.aboutwin, "menu.help_about")
        file_saveconfig.connect("activate", saveconfig, "menu.file_saveconfig")
        file_savepaths.connect("activate", savepaths, "menu.file_savepaths")
        file_savecrontab.connect("activate", savecrontab, "menu.file_savecrontab")
        file_saveall.connect("activate", saveall, "menu.file_saveall")
        help_help.connect("activate", viewhelp, "menu.help_help")
        
        #tabs
        notebook = gtk.Notebook()
        notebook.set_tab_pos(gtk.POS_TOP)
        tab0 = gtk.Label("Status")
        tab1 = gtk.Label("Basic Configuration")
        tab2 = gtk.Label("Paths to Backup")
        tab3 = gtk.Label("Crontab")
        scwin = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
        scwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scwin.show()
        notebook.append_page(vbox0, tab0)
        notebook.append_page(vbox1, tab1)
        notebook.append_page(scwin, tab2)
        notebook.append_page(vbox3, tab3)
        scwin.add_with_viewport(vbox2)
        config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
        table3 = gtk.Table(3, 1, True)
        time = config['time']
        adjustment = gtk.Adjustment(0, 0, 23, 1, 1, 0)
        adjustment.set_value(float(time))
        hscale = gtk.HScale(adjustment)
        hscale.set_digits(0)
        label_3 = gtk.Label('Select and hour to run the nightly backup at:\n'
                             '0 is the same as 12 AM, and 23 is the same as 12 PM.')
        label_3.show()
        table3.attach(label_3, 0, 1, 1, 2)
        table3.attach(hscale, 0, 1, 2, 3)
        notebook.set_size_request(555, 350)
        
        frame1 = gtk.Frame("Time")
        vbox0_1 = gtk.VBox(True, 0)
        var = str(time)
        statlbl1 = gtk.Label("Cronjob set to run " + var + " hours into the day, every day.\n"
                              "(Save configuration to update this value.)\n"
                              "Note that it will not run if the computer is turned off at that time.")
        statlbl1.set_justify(gtk.JUSTIFY_LEFT)
        frame1.add(statlbl1)
        frame1.show()
        statlbl1.show()
        
        frame2 = gtk.Frame("Configuration File")
        statlbl2 = gtk.Label("FWBackups successfully loaded the configuration file:\n"
                              '/etc/FWBackups.conf.d/config.conf')
        statlbl2.set_justify(gtk.JUSTIFY_LEFT)
        frame2.add(statlbl2)
        frame2.show()
        statlbl2.show()
        
        #pack all widgets
        vbox0_1.pack_start(frame1, False, False, 0)
        vbox0_1.pack_start(frame2, False, False, 0)
        vbox3.pack_start(table3, False, False, 0)
        table.attach(dirlabel, 0, 1, 0, 1)
        table.attach(dirent, 1, 2, 0, 1)
        table.attach(drivelabel, 0, 1, 1, 2)
        table.attach(driveent, 1, 2, 1, 2)
        table.attach(destlabel, 0, 1, 2, 3)
        table.attach(destent, 1, 2, 2, 3)
        vbox.pack_start(menubar, False, False, 0)
        vbox.pack_start(notebook, False, False, 0)
        vbox.pack_start(hseparator, False, False, 0)
        vbox.pack_start(statusbar)
        vbox1.pack_start(table, True, False, 0)
        vbox0.pack_start(vbox0_1, False, True, 0)
        
        #enter default configs
        config = shvarFile(normalize_path(['/etc/FWBackups.conf.d', 'config.conf']), True)
        dirent.set_text(config["dirent"])
        driveent.set_text(config["driveent"])
        destent.set_text(config["destent"])
        
        #show all
        hscale.show()
        table3.show()
        vbox0.show()
        vbox0_1.show()
        addent.show()
        add.show()
        img.show()
        label.show()
        add_hbox.show()
        hbox2.show()
        vbox3.show()
        vbox.show()
        notebook.show()
        hseparator.show()
        dirent.show()
        dirlabel.show()
        driveent.show()
        drivelabel.show()
        destent.show()
        destlabel.show()
        table.show()
        statusbar.show()
        file_saveconfig.show()
        file_savepaths.show()
        file_savecrontab.show()
        file_saveall.show()
        file_quit.show()
        file_open.show()
        help_help.show()
        help_about.show()
        help.show()
        file.show()
        filemenu.show()
        helpmenu.show()
        menubar.show()
        vbox1.show()
        vbox2.show()
        #add to window
        window.add
        window.add(vbox)
        
        #show window last
        window.show()
       
def main():
    gtk.main()
    return 0
if __name__ == "__main__":
    prog()
    main()
