/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * startjob_json_builder.h -- Build the string which contains the network
 *                            request to start a job
 */

#ifndef _STARTJOB_JSON_BUILDER_H
#define _STARTJOB_JSON_BUILDER_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <net_utils.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _startjob_json_builder {
	lwc_LL *json_key_values;
	lwc_LL *env;
	lwc_LL *args;
};
typedef struct _startjob_json_builder startjob_json_builder;
typedef struct _startjob_json_builder *startjob_json_builder_ptr;


extern startjob_json_builder_ptr startjob_json_builder_new OF(());
extern void startjob_json_builder_destroy OF((startjob_json_builder_ptr ptr));
extern void startjob_json_builder_add_argument OF((
				startjob_json_builder_ptr ptr,
				const char *val, unsigned int len_val));
extern void startjob_json_builder_add_environment OF((
					startjob_json_builder_ptr ptr,
					const char *key, const char *value));
extern void startjob_json_builder_add_key_value_string OF((
					startjob_json_builder_ptr ptr,
					const char *key,
					const char *val,
					unsigned int len_val));
extern void startjob_json_builder_add_key_value_bool OF((
					startjob_json_builder_ptr ptr,
					const char *key, char val));
extern void startjob_json_builder_add_jobid OF((
					startjob_json_builder_ptr ptr,
					int workload_date,
					unsigned long long int job_id));
extern int net_write_request OF((	startjob_json_builder_ptr ptr,
					schedwi_BIO *b,
					const char *module_name));

#define startjob_json_builder_add_path(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"path",VAL,LEN)
#define startjob_json_builder_add_command(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"command",VAL,LEN)
#define startjob_json_builder_add_username(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"user",VAL,LEN)
#define startjob_json_builder_add_fileout(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"stdout",VAL,LEN)
#define startjob_json_builder_add_filerr(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"stderr",VAL,LEN)
#define startjob_json_builder_add_cgroup(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"cgroup",VAL,LEN)
#define startjob_json_builder_add_loadenv(X,VAL,LEN) startjob_json_builder_add_key_value_bool(X,"user env",((VAL)[0]=='0')?0:1)
#define startjob_json_builder_add_detach(X,VAL,LEN) startjob_json_builder_add_key_value_bool(X,"detach",((VAL)[0]=='0')?0:1)
#define startjob_json_builder_add_filename(X,VAL,LEN) startjob_json_builder_add_key_value_string(X,"file",VAL,LEN)


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* startjob_json_builder.h */

/*-----------------============== End Of File ==============-----------------*/
