/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_status.h -- job status management functions */

#ifndef _SQL_STATUS_H
#define _SQL_STATUS_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <lwc_linkedlist.h>
#include <sql_common.h>

#define WAIT_REASON_MASK_PARENT            1
#define WAIT_REASON_MASK_TIME              2
#define WAIT_REASON_MASK_LINKS             4
#define WAIT_REASON_MASK_CONSTRAINT_FILE   8
#define WAIT_REASON_MASK_MODULE           16
#define WAIT_REASON_MASK_MANUAL           32

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_status_updated_workload_list OF((lwc_LL **rows,
			time_t time_status_set,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_get OF((int workload_date,
			unsigned long long int job_id,
			int *status,
			time_t *time_status_set,
			int *retry_num,
			int *wait_reason,
			char **message,
			long int *duration,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_update_wait_reason OF((int workload_date,
			unsigned long long int job_id,
			int wait_reason,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_set OF((int workload_date,
			unsigned long long int job_id,
			int status,
			time_t time_status_set,
			int retry_num,
			int wait_reason,
			const char *error_message,
			long int duration,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_delete OF((int workload_date,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_get_old OF((int workload_date,
			int (*callback)(void *, const char *, int),
			void *user_data,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_copy_to_workload OF((int workload_date,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_select_host OF((lwc_LL *host_ids,
			unsigned long long int *host_id_out,
			char **err_msg));
extern int sql_status_update_host_id OF((int workload_date,
			unsigned long long int job_id,
			unsigned long long int host_id,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_check_workload OF((int workload_date,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_status_num_waiting_links OF((int workload_date,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_status.h */

/*-----------------============== End Of File ==============-----------------*/
