/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_stat.h -- Update the statistics table (job_stat) */

#ifndef _SQL_STAT_H
#define _SQL_STAT_H

#include <schedwi.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_stat_success OF((
			unsigned long long int job_id,
			long int duration,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_stat_fail OF((
			unsigned long long int job_id,
			long int duration,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_stat.h */

/*-----------------============== End Of File ==============-----------------*/
