/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_hierarchy.h -- Get the job hierarchy and parameters */

#ifndef _SQL_HIERARCHY_H
#define _SQL_HIERARCHY_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern lwc_LL *hierarchy_list_new OF((	int workload_date,
					unsigned long long int job_id,
					char **err_msg));
extern void hierarchy_list_destroy OF((lwc_LL *lst));
extern int hierarchy_list_push_job OF((
			lwc_LL *lst, int workload_date,
			unsigned long long int job_id,
			char **err_msg));
extern void hierarchy_list_pop_job OF((lwc_LL *lst));
extern char *hierarchy_list_to_job_full_path OF((lwc_LL *lst));
extern char *hierarchy_array_to_str OF((unsigned long long int *a,
					unsigned int l));
extern char hierarchy_list_get_type OF((lwc_LL *lst));
extern char hierarchy_list_get_manual OF((lwc_LL *lst));
extern time_t hierarchy_list_get_start_time OF((lwc_LL *lst));
extern time_t hierarchy_list_get_real_start_time OF((lwc_LL *lst));
extern short int hierarchy_list_get_start_limit OF((lwc_LL *lst));
extern char *hierarchy_list_to_str OF((lwc_LL *lst));
extern unsigned long long int *hierarchy_list_to_array OF((lwc_LL *lst));
extern int get_job_parameters OF((
			int workload_date, lwc_LL *lst,
			const char *tablename, const char *colnames,
			row_item_t **values, char **err_msg));
extern int get_job_parameter OF((
			int workload_date, lwc_LL *lst,
			const char *tablename, const char *colname,
			row_item_t *value, char **err_msg));
extern int get_job_parameters_multi_row OF((
			int workload_date, lwc_LL *lst,
			const char *tablename, const char *colnames,
			const char *sort_colname,
			lwc_LL **rows, char **err_msg));
extern int get_job_parameters_multi OF((
			int workload_date, lwc_LL *lst,
			const char *tablename, const char *colnames,
			const char *sort_colname,
			int (*callback)(void *, row_item_t *), void *user_data,
			char **err_msg));
extern int get_job_hosts OF((
			int workload_date, lwc_LL *lst,
			lwc_LL **host_ids, char **err_msg));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_hierarchy.h */

/*-----------------============== End Of File ==============-----------------*/
