/* Schedwi
   Copyright (C) 2007-2010 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_common.h -- Useful MariaDB/MySQL functions */

#ifndef _SQL_COMMON_H
#define _SQL_COMMON_H

#include <schedwi.h>

#if STDC_HEADERS
#include <stdarg.h>
#endif

#include <schedwi_dbi.h>
#include <lwc_linkedlist.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	SQL_END,
	SQL_INT,
	SQL_STRING,
	SQL_STRING_NON_ESCAPE,
	SQL_BIN,
	SQL_BOOL
} sql_type;

typedef enum
{
	RES_END,
	RES_INT,
	RES_UINT,
	RES_STRING,
	RES_BIN,
	RES_TIME
} item_type;

struct row_item {
	item_type type;
	union {
		long long int value_int;
		unsigned long long int value_uint;
		char *value_string;
		time_t value_time;
	};
	size_t len;
};
typedef struct row_item row_item_t;


extern dbi_conn begin_sql OF((char **err_msg));
extern void end_sql OF(());
extern void compose_error_message OF((const char *msg, char **msg_out));
extern char *sql_escape OF((dbi_conn sql, const char *s));
extern int sql_non_select OF((	char **buf, unsigned int *buf_len,
				char **err_msg,
				unsigned long long int *id,
				unsigned long long int *affected_rows,
				const char *tablename,
				const char *fmt, ...));
extern void sql_free_row OF((row_item_t *row));
extern long long int sql_row_item2ll OF((const row_item_t *item));
extern int sql_select OF((	char **buf, unsigned int *buf_len,
				char **err_msg,
				unsigned int *num_columns,
				lwc_LL **rows,
				const char *fmt, ...));
extern char * sql_date_interval OF((int sec));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_common.h */

/*-----------------============== End Of File ==============-----------------*/
