/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_commands.h -- commands management functions */

#ifndef _SQL_COMMANDS_H
#define _SQL_COMMANDS_H

#include <schedwi.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_command_get_commands OF((
		int (*callback)(void *, int, unsigned long long int,
				const char *, int, int),
		void *user_data,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));
extern int sql_command_add OF((	int workload_date,
				unsigned long long int job_id,
				const char *user, int command,
				int parameter, char **err_msg));
extern int sql_command_done OF((
			int workload_date, unsigned long long int job_id,
			int command, int parameter,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));
extern int sql_command_failed OF((
			int workload_date, unsigned long long int job_id,
			int command, int parameter,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_commands.h */

/*-----------------============== End Of File ==============-----------------*/
