/* Schedwi
   Copyright (C) 2013-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_acknowledge_manual.h -- acknowledge_manual database table functions */

#ifndef _SQL_ACKNOWLEDGE_MANUAL_H
#define _SQL_ACKNOWLEDGE_MANUAL_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_acknowledge_add OF((int workload_date,
				unsigned long long int job_id,
				const char *urn, const char *password,
				char **err_msg));
extern int sql_acknowledge_get OF((int workload_date,
				unsigned long long int job_id,
				int *status,
				time_t *ack_time,
				char **username,
				void (*error_func)(void *, const char *, int),
				void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_acknowledge_manual.h */

/*-----------------============== End Of File ==============-----------------*/
