/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_time.h -- Time and date management functions */

#ifndef _SCHEDWI_TIME_H
#define _SCHEDWI_TIME_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif
#if TM_IN_SYS_TIME
#include <sys/time.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef time_t schedwi_time;

struct _schedwi_date {
	unsigned short int year;
	unsigned char month;
	unsigned char day;
};
typedef struct _schedwi_date schedwi_date;

extern void schedwi_date_add_days OF((	const schedwi_date *in,
					schedwi_date *out,
					int nb));
extern schedwi_time schedwi_time_add_minutes OF((schedwi_time in, int nb));
#define schedwi_time_add_seconds(in,nb) ((in)+(nb))
#define schedwi_time_now() time(NULL)
extern schedwi_time schedwi_time_to_midnight OF(());
extern time_t schedwi_last_midnight OF((time_t epoch));
extern char *schedwi_time_strftime OF((const char *format, const time_t *in));
extern time_t schedwi_time_convert OF((const schedwi_date *in, int hour_min));
extern time_t schedwi_time_convert_from_epoch OF((time_t epoch, int hour_min));
extern time_t schedwi_time_convert_from_string OF((const schedwi_date *in,
						const char *str));
extern time_t schedwi_time_convert_from_int OF((int year_month_day,
						int hour_min));
extern int schedwi_date_from_int OF((int year_month_day, schedwi_date *out));
extern int schedwi_date_from_string OF((const char *data_str,
					schedwi_date *out));
extern char *schedwi_date_to_string OF((schedwi_date in));
extern void schedwi_date_now OF((schedwi_date *out));
extern int schedwi_date_compar OF((	const schedwi_date *a,
					const schedwi_date *b));
extern char *schedwi_time_duration_to_str OF((unsigned long int nb_sec));
extern schedwi_date *schedwi_date_from_time_t OF((	time_t epoch,
							schedwi_date *out));
extern int schedwi_date_to_int OF((const schedwi_date *in));
extern int schedwi_time_to_date_int OF((time_t epoch));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_time.h */

/*-----------------============== End Of File ==============-----------------*/
