/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* result_mgnt.c -- Read/write job result status from/to file */

#ifndef _RESULT_MGNT_H
#define _RESULT_MGNT_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#if HAVE_STDIO_H
#include <stdio.h>
#endif

#define ERROR_MSG_LEN 255

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

#define WORKLOAD_LEN 8

struct result_str {
	char *job_id;			/* Job ID (20140623_12 for example) */
	unsigned int job_id_len;	/* Length of the job_id string */
	int workload_int;		/* YYYYMMDD (20140623 for example) */
	unsigned long long int job_id_int; /* Job ID (12 for example) */
	time_t duration;		/* Duration (in secondes) */
	char was_killed;		/* Is the job was killed (1 for yes) */
	int exit_code;			/* Exit code (or signal on kill) */
};
typedef struct result_str result_t;

extern result_t *result_new OF(());
extern void result_destroy OF((result_t *r));
extern result_t *str_to_result OF((const char *buffer, int buffer_size));
extern void result_set_id OF((	result_t *r, int workload_date,
				unsigned long long int job_id));
#define result_set_duration(RESULT,DURATION) (RESULT)->duration=(DURATION)

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* result_mgnt.h */

/*-----------------============== End Of File ==============-----------------*/
