/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_whoami.c -- Parse the `whoami' request */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include <net_utils_sock.h>
#include <memsend.h>
#include <reg_whoami.h>

int
reg_whoami (	int sock, const char *buff, ssize_t buff_len,
		const char *const *client_names)
{
	char first;
	int i;
	memsend_t *membuff;


	if (client_names == NULL || client_names[0] == NULL) {
		membuff = memsend_new ();
		memsend_append (membuff,
				"{ \"success\" : false, \"data\" : \"");
		memsend_append (membuff,
				_("Cannot get agent IP/name details"));
		memsend_append (membuff, "\" }");
		net_write_sock (sock, memsend_getstring (membuff),
				memsend_getlength (membuff));
		memsend_destroy (membuff);
		return -1;
	}

	membuff = memsend_new ();
	memsend_append (membuff,
			"{ \"success\" : true, \"data\" : { \"ip\" : \"");
	memsend_append (membuff, client_names[0]);
	memsend_append (membuff, "\"");

	if (client_names[1] != NULL) {
		i = (strcmp (client_names[0], client_names[1]) == 0) ? 2 : 1;
		if (client_names[i] != NULL) {
			memsend_append (membuff, ", \"dns\" : [ ");
			first = 1;
			do {
				if (first == 0) {
					memsend_append (membuff, ", \"");
				}
				else {
					first = 0;
					memsend_append (membuff, "\"");
				}
				memsend_append (membuff, client_names[i]);
				memsend_append (membuff, "\"");
				i++;
			} while (client_names[i] != NULL);
			memsend_append (membuff, " ]");
		}
	}
	memsend_append (membuff, " } }");
	net_write_sock (sock, memsend_getstring (membuff),
			memsend_getlength (membuff));
	memsend_destroy (membuff);
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
