/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_getca.c -- Parse the `getca' request */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <net_utils_sock.h>
#include <cert_utils.h>
#include <conf.h>
#include <utils.h>
#include <lwc_log.h>
#include <memsend.h>
#include <reg_getca.h>


static void
send_error (int sock, const char *error_message)
{
	memsend_t *membuff;


	membuff = memsend_new ();
	memsend_append (membuff, "{ \"success\" : false, \"data\" : \"");
	if (error_message != NULL) {
		memsend_append (membuff, error_message);
	}
	else {
		memsend_append (membuff, _("Cannot get the CA certificate"));
	}
	memsend_append (membuff, "\" }");
	net_write_sock (sock, memsend_getstring (membuff),
			memsend_getlength (membuff));
	memsend_destroy (membuff);
}


int
reg_getca (	int sock, const char *buff, ssize_t buff_len,
		const char *const *client_names)
{
	char *s, *serialized;
	const char *ca_crt;
	int ret;
	memsend_t *membuff;


	ret = conf_get_param_string ("SSLCACertificateFile", &ca_crt);
#if HAVE_ASSERT_H
	assert (ret == 0);
#endif

	s = read_file (ca_crt, NULL);
	if (s == NULL) {
		send_error (sock, NULL);
		return -1;
	}

	serialized = PEM2string (s);
	free (s);

	membuff = memsend_new ();
	memsend_append (membuff, "{ \"success\" : true, \"data\" : \"");
	memsend_append (membuff, serialized);
	free (serialized);
	memsend_append (membuff, "\" }");
	net_write_sock (sock, memsend_getstring (membuff),
			memsend_getlength (membuff));
	memsend_destroy (membuff);
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
