/* Schedwi
   Copyright (C) 2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_error_code.h -- Registration error codes */

#include <schedwi.h>

#include <reg_error_code.h>


/*
 * Convert the provided error code to a string (to use in JSON strings)
 */
const char *
reg_error_to_string (error_reason_t reason)
{
	switch (reason) {
		case REG_SYSTEM_ERROR:		return "1";
		case REG_NO_CSR:		return "2";
		case REG_NOT_READY_YET:		return "3";
		case REG_CRT_PRESENT:		return "4";
		case REG_CSR_PRESENT:		return "5";
		case REG_ERROR_CSR:		return "6";
		default:			return "0";
	}
}

/*-----------------============== End Of File ==============-----------------*/
