/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_utils.h -- Useful network functions */

#ifndef _NET_UTILS_H
#define _NET_UTILS_H

#include <schedwi.h>

#if HAVE_STDARG_H
#include <stdarg.h>
#endif

#include <net_utils_sock.h>
#include <net_utils_ssl.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _schedwi_BIO {
	char use_ssl;
	int fd;
	gnutls_session_t session;
	gnutls_certificate_credentials_t *trusted_cert_ptr;
};
typedef struct _schedwi_BIO schedwi_BIO;

extern int net_init OF((const char *schedwisrv_crt_file,
			const char *schedwisrv_key_file,
			const char *schedwisrv_ca_file,
			const char *schedwisrv_crl_file,
			char quick_random));
extern int net_init_server OF(());
extern void net_destroy OF(());
extern int net_accept OF((	fd_set *sock_set, int max_set, int *nb_set,
				const char *allow_from,
				struct sockaddr_storage *out_sockname,
				socklen_t *out_len));
extern int net_accept_sock OF((	fd_set *sock_set, int sock_max,
				const char *allow_from, char ***names));
extern schedwi_BIO *net_client OF((const char *port_number,
			const char *hostname, char use_ssl,
			char *remote_crt, unsigned int remote_crt_len));
extern int net_read OF((schedwi_BIO *in, char **buff, size_t *len));
extern int net_read_result OF((schedwi_BIO *in, char **result_msg));
extern int net_write OF((schedwi_BIO *out, const char *buff, int len));
extern int net_write_strings OF((schedwi_BIO *out, ...));
extern void net_close OF((schedwi_BIO *out));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils.h */

/*-----------------============== End Of File ==============-----------------*/
