/* Schedwi
   Copyright (C) 2013-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* manual_trigger.h -- Alert someone that a manual job is waiting */

#ifndef _MANUAL_TRIGGER_H
#define _MANUAL_TRIGGER_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <job_status_node.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int check_manual_trigger OF((	job_status_node_ptr ptr,
					lwc_LL *hierarchy_list,
					time_t start_time,
					short int start_limit));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* manual_trigger.h */

/*-----------------============== End Of File ==============-----------------*/
