/* Schedwi
   Copyright (C) 2007-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* lwc_linkedlist.c -- Linked list functions */

#ifndef _LWC_LINKEDLIST_H
#define _LWC_LINKEDLIST_H

#include <schedwi.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Node of the linked list:
 *    next --> next node
 *    prev --> previous node
 *     obj --> associated object
 */
struct _lwc_linkedNode {
	struct _lwc_linkedNode *next;
	struct _lwc_linkedNode *prev;
	void *obj;
};

/*
 * Linked list object/header:
 *   start --> Pointer to the first node of the linked list
 *     end --> Pointer to the last node of the linked list
 *     ptr --> Pointer to the current node (used to visit all nodes;
 *             see lwc_rewindLL() and lwc_nextLL())
 *     num --> Number of nodes in the linked list
 */
struct _lwc_linkedHead {
	struct _lwc_linkedNode *start;
	struct _lwc_linkedNode *end;
	struct _lwc_linkedNode *ptr;
	int num;
};
typedef struct _lwc_linkedHead lwc_LL;


extern lwc_LL * lwc_newLL OF(());
extern void   lwc_delLL   OF((lwc_LL *ptr, void (*deleteNode)(const void *)));
extern void   lwc_emptyLL OF((lwc_LL *ptr, void (*deleteNode)(const void *)));
extern void * lwc_searchSortLL OF((lwc_LL *ptr, const void *key,
				int (*compar)(const void *, const void *)));
extern void * lwc_searchLL   OF((lwc_LL *ptr, const void *key,
				int (*compar)(const void *, const void *)));
extern int    lwc_addLL      OF((lwc_LL *ptr, void *key,
				int (*compar)(const void *, const void *)));
extern int    lwc_replaceLL  OF((lwc_LL *ptr, void *key,
				int (*compar)(const void *, const void *),
				void **old));
extern int    lwc_replaceUnsortedLL OF((lwc_LL *ptr, void *key,
				int (*compar)(const void *, const void *),
				void **old));
extern int    lwc_addStartLL OF((lwc_LL *ptr, void *key));
extern int    lwc_addEndLL   OF((lwc_LL *ptr, void *key));
extern void * lwc_delStartLL OF((lwc_LL *ptr));
extern void * lwc_delEndLL   OF((lwc_LL *ptr));
extern void * lwc_delNodeLL  OF((lwc_LL *ptr, const void *key,
				int (*compar)(const void *, const void *)));
extern void * lwc_delUnsortedNodeLL  OF((lwc_LL *ptr, const void *key,
				int (*compar)(const void *, const void *)));
extern void   lwc_rewindLL   OF((lwc_LL *ptr));
extern void * lwc_nextLL     OF((lwc_LL *ptr));
extern void * lwc_delCurrentLL OF((lwc_LL *ptr));
extern void   lwc_concatUnsortedLL OF((lwc_LL *src, lwc_LL *dst));

#define lwc_getNumNode(ptr) (((ptr) == (lwc_LL *)0) ? 0 : (ptr)->num)

#ifdef __cplusplus
}
#endif

#endif /* _LWC_LINKEDLIST_H */

/******************************** End Of File ********************************/
