/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* job_status_state.h -- Job status definition */

#ifndef _JOB_STATUS_STATE_H
#define _JOB_STATUS_STATE_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	JOB_STATUS_STATE_UNDEFINED = 0,
	JOB_STATUS_STATE_WAITING = 1,
	JOB_STATUS_STATE_RUNNING,
	JOB_STATUS_STATE_COMPLETED,
	JOB_STATUS_STATE_FAILED,
	JOB_STATUS_STATE_COMPLETED_OR_FAILED,

	NUM_JOB_STATUS_STATE
} job_status_state;

extern job_status_state job_status_state_int2status OF((int i));
extern int job_status_state_status2int OF((job_status_state status));
extern char *job_status_state2str OF((job_status_state status));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_status_state.h */

/*-----------------============== End Of File ==============-----------------*/

