/* Schedwi
   Copyright (C) 2014, 2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* job_status_set.h -- Set the status of a job */

#ifndef _JOB_STATUS_SET_H
#define _JOB_STATUS_SET_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <lwc_linkedlist.h>
#include <result_mgnt.h>
#include <job_status_node.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int job_status_set OF((	const result_t *result,
				const char *job_name_with_path,
				job_status_state new_state,
				job_status_state previous_state,
				time_t status_time,
				long int duration,
				int retry_num,
				int wait_reason,
				const char *status_message));
extern int job_change_status OF((	lwc_LL *hierarchy_list,
					const result_t *result,
					job_status_state new_state,
					const char *status_message));
extern int job_status_force OF((	lwc_LL *hierarchy_list,
					job_status_node_ptr job_details));
extern int job_status_set_mem_add OF((	lwc_LL *lst,
					const result_t *result,
					const char *job_name_with_path,
					job_status_state new_state,
					job_status_state previous_state,
					time_t status_time,
					int wait_reason));
extern int job_status_set_mem_flush OF((lwc_LL *lst));
extern void job_status_set_mem_destroy OF((lwc_LL *lst));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_status_set.h */

/*-----------------============== End Of File ==============-----------------*/
