/* Schedwi
   Copyright (C) 2014, 2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file job_status_node.h
 * Manage the job_status_node object (status parameters of a job/jobset)
 */

#ifndef _JOB_STATUS_NODE_H
#define _JOB_STATUS_NODE_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <lwc_linkedlist.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _job_status_node {
	int workload_date;
	unsigned long long int job_id;
	char *workload_jobid;
	char *job_name_with_path; 

	/* From the job_status table (retrieved by sql_status_get()) */
	job_status_state status;
	time_t time_status_set;
	int retry_num;
	int wait_reason;
	char *message;
	long int duration;

	/* To save the status when a new status is set */
	job_status_state previous_status;
	time_t previous_time_status_set;
};
typedef struct _job_status_node job_status_node;
typedef struct _job_status_node *job_status_node_ptr;

extern job_status_node_ptr job_status_node_new OF(());
extern void job_status_node_destroy OF((job_status_node_ptr ptr));
extern job_status_node_ptr job_status_node_get OF((
					int workload_date,
					unsigned long long int job_id,
					const char *job_name_with_path));
extern void job_status_node_set_message OF((	job_status_node_ptr ptr,
						const char *new_message));
extern void job_status_node_set_status OF((	job_status_node_ptr ptr,
						job_status_state new_status,
						time_t status_time));
extern int job_status_node_set_wait_reason OF((	job_status_node_ptr ptr,
						int wait_reason));
extern int job_status_node_set OF((	lwc_LL *hierarchy_list,
					job_status_node_ptr ptr));
#define job_status_has_changed(ptr) ((ptr)->previous_status != (ptr)->status)

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_status_node.h */

/*-----------------============== End Of File ==============-----------------*/

