/* Schedwi
   Copyright (C) 2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* get_job_status_from_agents.h -- Wait and manage agent connections */

#ifndef _GET_JOB_STATUS_FROM_AGENTS_H
#define _GET_JOB_STATUS_FROM_AGENTS_H

#include <schedwi.h>

#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int get_job_status_from_agents OF((	fd_set *sock_set,
						int sock_max,
	       					const char *allow_from));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* get_job_status_from_agents.h */

/*-----------------============== End Of File ==============-----------------*/
