/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * env_utils.h -- Environment array management functions
 *
 * The environment array is an array of strings.  By convention these strings
 * have the form `name=value'.  This array is embedded in the environment_t
 * structure but can be used directly by system functions like exec.
 */

#ifndef _ENV_UTILS_H
#define _ENV_UTILS_H

#include <schedwi.h>

#if STDC_HEADERS
#include <string.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct env_str {
	char **env;
	int length;
	int idx;
};

typedef struct env_str environment_t;

extern void init_environment OF((environment_t *e));
extern void destroy_environment OF((environment_t *e));
extern void add_env_s OF((	environment_t *e,
				const char *key, size_t key_len,
				const char *val, size_t val_len));
extern void add_env OF((environment_t *e, const char *key, const char *val));
extern int search_environment OF((	environment_t *e,
					const char *var, size_t var_len));
extern const char *getvar_environment OF((environment_t *e, int idx));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* env_utils.h */

/*-----------------============== End Of File ==============-----------------*/
