/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* conf_srv.c -- Configuration file management functions (srv) */

#include <schedwi.h>
#include <module.h>
#include <conf.h>
#include <conf_srv.h>

/*
 * Parameter list
 */
static conf_param_t params_clnt[] = {
	{ "USER", STRING, {0}, 0, 0, 0, 0},
	{ "GROUP", STRING, {0}, 0, 0, 0, 0},
	{ "LOG_FILE", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_LOGFILE},
	{ "SYSLOG", SYSLOG_FACILITY, {0}, check_syslog_facility, 0, 0, 0},
	{ "DATE_FORMAT", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_DATEFORMAT},
	{ "PID_FILE", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_PIDFILE},
	{ "PID_FILE_REGISTRAR", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_PIDFILE_REG},
	{ "MANUAL_TRIGGER_TEMPLATE_FILE", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_MANUAL_TRIGGER_TEMPLATE_FILE},
	{ "WORKLOAD_PURGE_COMPLETED", INT, {0}, check_int, 0, 0, SCHEDWI_DEFAULT_WORKLOAD_PURGE_COMPLETED},
	{ "WORKLOAD_PURGE_FAILED", INT, {0}, check_int, 0, 0, SCHEDWI_DEFAULT_WORKLOAD_PURGE_FAILED},
	{ "TODAY_WORKLOAD_SKIP", INT, {0}, check_int, 0, 0, SCHEDWI_DEFAULT_TODAY_WORKLOAD_SKIP},
	{ "ALLOW_FROM", STRING, {0}, check_netlist, 0, 0, ""},
	{ "SERVER_PORT", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SRVPORT},
	{ "REGISTRAR_PORT", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_REGPORT},
	{ "ADDRESS_FAMILY", STRING, {0}, check_addrfamily, 0, 0, SCHEDWI_DEFAULT_ADDRESS_FAMILY},
	{ "IFACE_LISTEN", STRING, {0}, 0, 0, 0, 0},
	{ "SSLCertificateFile", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CERTIFICATE_FILE},
	{ "SSLCertificateKeyFile", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CERTIFICATE_KEY_FILE},
	{ "SSLCommonName", STRING, {0}, 0, 0, 0, 0},
	{ "SSLCACertificateFile", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CA_CERTIFICATE_FILE},
	{ "SSLCACertificateKeyFile", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CA_CERTIFICATE_KEY_FILE},
	{ "SSLCACRLFile", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CA_CRL_FILE},
	{ "SSLCACountry", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_COUNTRY},
	{ "SSLCAOrganization", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_ORGANIZATION},
	{ "SSLCAUnit", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_OU},
	{ "SSLCALocality", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_LOCALITY},
	{ "SSLCAState", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_STATE},
	{ "SSLCACommonName", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CA_CN},
	{ "SSLCAEmail", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CA_EMAIL},
	{ "SSLAgentCertificateDir", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CLNT_CERTIFICATE_DIR},
	{ "SSLAgentRequestDir", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CLNT_REQUEST_DIR},
	{ "SSLAgentSaveRequestDir", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_SSL_CLNT_SAVE_REQUEST_DIR},
	{ "SSLQuickRandom", BOOL, {0}, check_bool, 0, 0, "1"},
	{ "DBI_DRIVERDIR", STRING, {0}, 0, 0, 0, 0},
	{ "DBI_DRIVERNAME", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_DBI_DRIVERNAME},
	{ "DBI_USER", STRING, {0}, 0, 0, 0, 0},
	{ "DBI_PASSWORD", STRING, {0}, 0, 0, 0, 0},
	{ "DBI_DBDIR", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_DBI_DBDIR},
	{ "DBI_DBHOSTNAME", STRING, {0}, 0, 0, 0, "localhost"},
	{ "DBI_DBNAME", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_DBI_DBNAME},
	{ "DBI_FREETDS_VERSION", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_DBI_FREETDS_VERSION},
	{ "DBI_ENCODING", STRING, {0}, 0, 0, 0, 0},
	{ "GUI_REFRESH", INT, {0}, check_int, 0, 0, SCHEDWI_DEFAULT_GUI_REFRESH},
	{ "GUI_USERNAME", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_USERNAME},
	{ "GUI_PASSWORD", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_PASSWORD},
	{ "GUI_IFACE_LISTEN", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_IFACE_LISTEN},
	{ "GUI_PORT", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_PORT},
	{ "GUI_LOG_FILE", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_LOGFILE},
	{ "GUI_CONTEXT_ROOT", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_GUI_CONTEXT_ROOT},
	{ "GUI_SSLCertificateFile", STRING, {0}, 0, 0, 0, ""},
	{ "GUI_SSLCertificateKeyFile", STRING, {0}, 0, 0, 0, ""},
	{ "PAM_AUTH", BOOL, {0}, check_bool, 0, 0, "0"},
	{ "PAM_AUTH_SERVICE", STRING, {0}, 0, 0, 0, SCHEDWI_DEFAULT_PAM_AUTH_SERVICE},
	{ "MODULE_DIR", FUNCTION, {0}, 0, module_path, 0, 0},
	{ "MODULE_LOAD", FUNCTION, {0}, 0, module_load, 0, 0},
	{ 0, INT, {0}, 0, 0, 0, 0}
};

/*
 * Fill the parameter array by reading the provided configuration file
 *
 * Return:
 *   0 --> No error
 *  -2 --> System error while accessing the configuration file (errno is set)
 *  -3 --> Syntax error in the configuration file.  The errors are sent to
 *	   stderr
 */
int
conf_init_srv (const char *file_name)
{
	return conf_init (file_name, params_clnt);
}


/*
 * Destroy (free) the content of the parameter array
 */
void
conf_destroy_srv ()
{
	conf_destroy ();
}

/*------------------------======= End Of File =======------------------------*/
