/* Schedwi
   Copyright (C) 2013-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* check_waiting_can_start.h -- Check if a waiting job/jobset can start */

#ifndef _CHECK_WAITING_CAN_START_H
#define _CHECK_WAITING_CAN_START_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#include <job_status_node.h>
#include <lwc_linkedlist.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int check_waiting_can_start OF((	job_status_node_ptr ptr,
					lwc_LL *hierarchy_list,
					time_t now,
					job_status_state parent_status));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* check_waiting_can_start.h */

/*-----------------============== End Of File ==============-----------------*/
