/* Schedwi
   Copyright (C) 2011-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* cert_utils.h -- Functions around GnuTLS */

#ifndef _CERT_UTILS_H
#define _CERT_UTILS_H

#include <schedwi.h>

#include <gnutls/gnutls.h>
#include <gnutls/x509.h>

#define CSR_EMAIL_PREFIX "root@"

#define CRT_EXTENSION ".crt"
#define CSR_EXTENSION ".csr"
#define NOSSL_EXTENSION ".nossl"
#define TMP_EXTENSION ".tmp"


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern char *PEM2string OF((const char *pemstr));
extern char *string2PEM OF((const char *pemstr));
extern gnutls_x509_privkey_t generate_private_key OF((	const char *outfile,
							const char *user,
							const char *group));
extern gnutls_x509_crq_t generate_request OF((	gnutls_x509_privkey_t key,
		  				char **dnsnames,
						const char *ip));

typedef enum {
	CERT,
	REQ
} type_data;

extern int my_gnutls_x509_crt_check_hostname OF((void *cert_or_crq,
						type_data t,
						const char *const *hostnames));
extern gnutls_x509_privkey_t load_private_key OF((const char *infile));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* cert_utils.h */

/*-----------------============== End Of File ==============-----------------*/
