/* Schedwi
   Copyright (C) 2007-2015 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * args_utils.h -- Arguments array management functions
 *
 * The arguments array is an array of strings.  This array is embedded in the
 * argument_t structure but can be used directly by system functions like exec.
 */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include <xmem.h>
#include <args_utils.h>

/*
 * Init the argument structure
 */
void
init_argument (argument_t *e)
{
	if (e != NULL) {
		e->arg = NULL;
		e->length = 0;
		e->idx = 0;
	}
}


/*
 * Free the argument structure
 */
void
destroy_argument (argument_t *e)
{
	int i;

	if (e != NULL) {
		if (e->arg != NULL && e->length > 0) {
			for (i = 0; i < e->idx; i++) {
				if ((e->arg)[i] != NULL) {
					free ((e->arg)[i]);
				}
			}
			free (e->arg);
		}
		e->arg = NULL;
		e->length = 0;
		e->idx = 0;
	}
}


/*
 * Add an argument at the end of the array
 */
void
add_arg_s (	argument_t *e,
		const char *val, size_t val_len)
{
	char **tmp;


	if (e == NULL || val == NULL || val_len == 0) {
		return;
	}

	if (e->idx + 1 >= e->length) {
		tmp = (char **) xrealloc (e->arg,
					(e->length + 10) * sizeof (char **));
		e->arg = tmp;
		e->length += 10;
	}

	(e->arg)[e->idx] = (char *) xmalloc (val_len + 1);
	strncpy ((e->arg)[e->idx], val, val_len);
	(e->arg)[e->idx][val_len] = '\0';
	(e->arg)[++e->idx] = NULL;
}


/*
 * Add an argument at the end of the array
 */
void
add_arg (argument_t *e, const char *val)
{
	add_arg_s (e, val, strlen (val));
}

/*-----------------============== End Of File ==============-----------------*/
