# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKeyConstraint
from sqlalchemy.types import Integer

from base import Base


class link_s(Base):
    __tablename__ = 'link_s'
    __table_args__ = (
        ForeignKeyConstraint(['job_id_source', 'workload_date'],
                             ['job_main_s.id', 'job_main_s.workload_date']),
        ForeignKeyConstraint(['job_id_destination', 'workload_date'],
                             ['job_main_s.id', 'job_main_s.workload_date']),
        {})

    job_id_source = Column(Integer, primary_key=True)
    job_id_destination = Column(Integer, primary_key=True)
    required_status = Column(Integer)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, job_id_destination, required_status, workload_date):
        self.job_id_destination = job_id_destination
        self.required_status = required_status
        self.workload_date = workload_date

    def copy(self):
        return link_s(self.job_id_destination, self.required_status,
                      self.workload_date)
