# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKey
from sqlalchemy.types import Integer, String

from base import Base, convert2unicode


class job_control_group(Base):
    __tablename__ = 'job_control_group'

    job_id = Column(Integer, ForeignKey('job_main.id'), primary_key=True)
    control_group = Column(String(255))

    def __init__(self, control_group):
        self.control_group = convert2unicode(control_group)

    def copy(self):
        return job_control_group(self.control_group)
