# Schedwi
# Copyright (C) 2011-2015 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sqlalchemy.orm.session
from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String
from sqlalchemy.orm import relation
from sqlalchemy.sql import func

from base import Base, convert2unicode

from environment_var_s import environment_var_s


class environments_s(Base):
    __tablename__ = 'environments_s'

    id = Column(Integer, primary_key=True)
    name = Column(String(100))
    description = Column(Text)
    workload_date = Column(Integer, primary_key=True)

    environment_var = relation(environment_var_s,
                               order_by=environment_var_s.position,
                               backref="environments_s",
                               cascade="all, delete, delete-orphan")

    def __init__(self, id, name, description, workload_date):
        self.id = id
        self.name = convert2unicode(name)
        self.description = convert2unicode(description)
        self.workload_date = workload_date

    def __str__(self):
        return self.name


def get_next_id(sql_session, workload):
    """Return the next available ID from the environments_s database table.

    @param sql_session:
                SQLAlchemy session (it can be an opened session)
    @param workload:
                the workload to look for (YYYYMMDD)
    @return:
                The next available ID.
    """
    if not isinstance(sql_session, sqlalchemy.orm.session.Session):
        session = sql_session.open_session()
    else:
        session = sql_session

    query = session.query(func.max(environments_s.id).label("max_id"))
    try:
        res = query.filter(environments_s.workload_date == workload).one()
    except:
        new_id = 1
    else:
        new_id = res.max_id + 1

    if not isinstance(sql_session, sqlalchemy.orm.session.Session):
        sql_session.close_session(session)
    return new_id
