# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String
from sqlalchemy.orm import relation

from base import Base, convert2unicode
from host_clusters import host_clusters


class clusters(Base):
    __tablename__ = 'clusters'

    id = Column(Integer, primary_key=True)
    name = Column(String(100))
    description = Column(Text)

    host_clusters = relation(host_clusters,
                             backref="clusters",
                             cascade="all, delete, delete-orphan")

    def __init__(self, name, description):
        self.name = convert2unicode(name)
        self.description = convert2unicode(description)

    def __str__(self):
        return self.name
