# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKeyConstraint
from sqlalchemy.types import Integer, String, SmallInteger, DateTime

from base import Base, convert2unicode


class acknowledge_manual(Base):
    __tablename__ = 'acknowledge_manual'
    __table_args__ = (
        ForeignKeyConstraint(['job_id', 'workload_date'],
                             ['job_main_s.id', 'job_main_s.workload_date']),
        {})

    job_id = Column(Integer, primary_key=True)
    username = Column(String(100))
    ack_time = Column(DateTime)
    status = Column(SmallInteger)       # 0: Waiting ack   1: Acknowledged
    urn = Column(String(20))
    password = Column(String(20))
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, job_id, username, status, urn, password, workload_date):
        self.job_id = job_id
        self.username = convert2unicode(username)
        self.status = status
        self.urn = convert2unicode(urn)
        self.password = convert2unicode(password)
        self.workload_date = workload_date
