# Schedwi
# Copyright (C) 2011-2015 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Command line colorization."""

#!/usr/bin/python

import os

if not os.isatty(1):
    WITH_COLORS = False
    BLUE = GREEN = CYAN = RED = MAGENTA = YELLOW = WHITE = BLACK = HIGH = '['
    NORMAL = ']'
    CHAR_COLOR_LEN = 1
else:
    WITH_COLORS = True
    c = {
        'lc': '\x1b[',  # LEFTCODE
        'rc': 'm',      # RIGHTCODE
        'no': '00',     # NORMAL
        'di': '01;34',  # Directory
        'fi': '00',     # File
        # Specific for Schedwi
        'np': '37'      # Not planned
    }

    try:
        for i in os.environ['LS_COLORS'].split(':'):
            try:
                v, k = i.split('=')
                c[v] = k.replace('\e', '\x1b')
            except:
                pass
    except:
        pass
    if 'ec' not in c:
        c['ec'] = c['lc'] + c['no'] + c['rc']

    # See dir_colors(5) for color codes
    BLUE = c['lc'] + '44;37;01' + c['rc']
    GREEN = c['lc'] + '42;37;01' + c['rc']
    CYAN = c['lc'] + '46;37;01' + c['rc']
    RED = c['lc'] + '41;37;01' + c['rc']
    MAGENTA = c['lc'] + '45;37;01' + c['rc']
    YELLOW = c['lc'] + '43;30;01' + c['rc']
    WHITE = c['lc'] + '00' + c['rc']
    BLACK = c['lc'] + '40;37;01' + c['rc']
    HIGH = BLACK
    NORMAL = c['ec']
    CHAR_COLOR_LEN = 0


def color_file(s):
    if WITH_COLORS:
        return c['lc'] + c['fi'] + c['rc'] + s + c['ec']
    else:
        return s


def color_dir(s):
    if WITH_COLORS:
        return c['lc'] + c['di'] + c['rc'] + s + c['ec']
    else:
        return s


def color_notplanned(s):
    if WITH_COLORS:
        return c['lc'] + c['np'] + c['rc'] + s + c['ec']
    else:
        return s
