# Schedwi
# Copyright (C) 2011-2015 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to force start jobs and jobsets."""

import sys
import getopt

import path
from tables.commands import commands
import parse_config
import config
import status_utils
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: start [OPTIONS]... JOB|JOBSET...
        Force the start of JOBs and JOBSETs.

        Option:
          -h, --help  display this help.
    """))


def start_id(session, job_id, workload):
    query = session.query(commands).filter(commands.job_id == job_id)
    query = query.filter(commands.workload_date == workload)
    query = query.filter(commands.command_status == 0)
    query = query.filter(commands.command == 1)
    query = query.filter(commands.parameter == status_utils.RUNNING)
    if not query.count():
        c = commands(job_id, parse_config.DBI_USER, 0, 1,
                     status_utils.RUNNING, workload)
        session.add(c)


def start(sql_session, current_cwd, arguments, workload):
    """Start jobs and jobsets.

    Arguments:
    sql_session -- SQLAlchemy session
    current_cwd -- current working jobset (a path.Path object)
    arguments -- list of arguments given to the start command (list
                 of jobs/jobsets)
    workload -- workload to use

    """
    try:
        optlist, args = getopt.getopt(arguments, "h", ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write(_("start: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    paths = list()
    if args:
        for arg in args:
            p = path.get_paths(sql_session, arg, current_cwd,
                               workload=workload)
            # An argument is an unknow path
            if not p:
                sys.stderr.write(_("start: `%s': no such job or jobset\n")
                                 % arg.decode('utf-8'))
                return 1
            paths.extend(p)
    else:
        sys.stderr.write(_("start: missing job or jobset operand\n"))
        return 1
    session = sql_session.open_session()
    for p in paths:
        start_id(session, p.id[-1], workload)
    sql_session.close_session(session)
    if config.ISATTY_STDOUT:
        print _("This may take up to a minute to be taken into account")
    return 0
