# Schedwi
# Copyright (C) 2013-2015 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to remove clusters."""

import sys
import getopt

import cluster_utils
import whatuses
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: rm CLUSTER...
        Remove each specified cluster.

        Option:
          -h, --help  display this help.
    """))


def rm(sql_session, arguments):
    """Remove clusters.

    @param sql_session:
                SQLAlchemy session
    @param arguments:
                list of arguments given to the rm command (list of clusters)
    @return:
                0 on success and 1 on error
    """
    try:
        optlist, args = getopt.getopt(arguments, "h", ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write(_("rm: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    if not args:
        sys.stderr.write(_("rm: missing operand\n"))
        return 1
    session = sql_session.open_session()
    error = False
    for a in args:
        cluster_list = cluster_utils.name2cluster_list(session, a)
        if not cluster_list:
            sys.stderr.write(_("rm: `%s': no such cluster\n")
                             % a.decode('utf-8'))
            error = True
        else:
            for c in cluster_list:
                if whatuses.is_used(session, c):
                    sys.stderr.write(_("rm: `%s' is used (run `whatuses %s' \
for more details)\n") % (c, c))
                    error = True
                else:
                    session.delete(c)
    if error:
        sql_session.cancel_session(session)
        return 1
    sql_session.close_session(session)
    return 0
