/* Schedwi
   Copyright (C) 2007-2010 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * srvtest_version.c -- Test program for the Schedwi agent
 *
 * Output:
 *     stdout) The result of the command execution send by the schedwiclnt
 *
 * Return:
 *   0 on success or
 *   an other return code for error
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#if HAVE_NETDB_H
#include <netdb.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef HAVE_RECV
#define recv(a,b,c,d) read(a,b,c)
#endif

#ifndef HAVE_SEND
#define send(a,b,c,d) write(a,b,c)
#endif

#ifndef PF_INET
#define PF_INET AF_INET
#endif

#ifndef HAVE_CLOSESOCKET
#define closesocket(x) close(x)
#endif

/*
 * memset - fill memory with a constant byte
 */
void *
schedwi_memset (void *s, int c, unsigned int n)
{
        char *tmp = s;

        if (s != 0) {
                while (n/10 != 0) {
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        n -= 10;
                }
                while (n > 0) {
                        *(tmp++) = c;
                        n--;
                }
        }
        return s;
}


/*
 * atoi - convert a string to an integer (very simplified version)
 */
int
schedwi_atoi (const char *s)
{
	size_t i;
	int val;

	if (s == NULL) {
		return 0;
	}

	while (*s != '\0' && (*s == ' ' || *s == '\t')) {
		s++;
	}

	val = 0;
	for (i = 0; s[i] != '\0' && s[i] >= '0' && s[i] <= '9'; i++) {
		val *= 10;
		val += s[i] - '0';
	}
	return val;
}


/*
 * Send a version request to the client
 */
int
send_version ()
{
	int sock;
	struct sockaddr_in sad;
	char buff[4096];
	ssize_t nb_read;
	struct hostent *he;

	/* Get the address of the local host */
	he = gethostbyname ("127.0.0.1");
	if (he == NULL) {
		return 8;
	}

	/* Create the socket */
	sock = socket (PF_INET, SOCK_STREAM, 0);
	if (sock < 0) {
		return 9;
	}

	/* Compose the remote address */
	schedwi_memset (&sad, 0, sizeof(sad));
        sad.sin_family = AF_INET;
        sad.sin_addr.s_addr = *((unsigned long *)(he->h_addr_list[0]));
	sad.sin_port = htons (schedwi_atoi (SCHEDWI_DEFAULT_AGTPORT));

	/* Connect to the address */
	if (connect (sock, (struct sockaddr *)&sad, sizeof(sad)) != 0) {
		closesocket (sock);
		return 10;
	}

	/* Build and send the header */
	send (sock, "[ \"version\" ]", 13, 0);

	/* Read the reply and dump it to stdout */
	do{
		nb_read = recv (sock, buff, 4096, 0);
		if (nb_read == 0) {
			break;
		}
		if (nb_read < 0) {
			closesocket (sock);
			return 11;
		}
		write (1, buff, nb_read);
	} while (1);

	closesocket (sock);

	return 0;
}


/*
 * Main function
 */
int
main (int argc, char **argv)
{
	/*
	 * Send the version request 
	 */
	return send_version ();
}

/*------------------------======= End Of File =======------------------------*/
