/* Schedwi
   Copyright (C) 2012-2014 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* @file memsend.h
 * Memory buffer to store data (append allowed)
 */

#ifndef _MEMSEND_H
#define _MEMSEND_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct memsend_str {
	char *buff;
	unsigned int idx;
	unsigned int len;
};
typedef struct memsend_str memsend_t;

extern memsend_t *memsend_new OF(());
extern void memsend_destroy OF((memsend_t *r));
extern const char *memsend_getstring OF((memsend_t *r));
extern unsigned int memsend_getlength OF((memsend_t *r));
extern void memsend_clear OF((memsend_t *r));
extern void memsend_append_len OF((memsend_t *r, const char *s, size_t len));
extern void memsend_append OF((memsend_t *r, const char *s));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* memsend.h */

/*-----------------============== End Of File ==============-----------------*/
