/* Schedwi
   Copyright (C) 2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* cert_ca.c -- Tools for a certificate authority */

#ifndef _CERT_CA_H
#define _CERT_CA_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <gnutls/gnutls.h>
#include <gnutls/x509.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int cert_check_and_create OF((	const char *file_ca_cert,
					const char *file_ca_key,
					const char *file_cert,
					const char *file_key,
					const char *user,
					const char *group,
					char quick_random));
extern gnutls_x509_crt_t load_cert_from_mem OF((const char *certstr,
						size_t lengthstr,
						const char *infile));
extern char * get_hostname_from_cert OF((gnutls_x509_crt_t cert));
extern int sign_request OF((const char *ca_keyfile, const char *ca_crtfile,
			const char *csrfile, const char *outsignedcrt));
extern int revoke_certificate OF((const char *ca_keyfile,
			const char *ca_crtfile,
			const char *crt2revoke, const char *crl_file));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* cert_ca.h */

/*-----------------============== End Of File ==============-----------------*/
