Summary: A task scheduler
Name: schedwisrv
Version: 0.1.6
Release: 1%{?dist}
License: GPL
Group: System Environment/Daemons
URL: http://www.nongnu.org/schedwi
Source: http://www.nongnu.org/schedwi/download/%{name}-%{version}.tar.gz
Requires: initscripts, tcp_wrappers, gnutls >= 2.2.0, libdbi, libdbi-dbd-sqlite, mailx, openssl, schedwisrv-common, python-muntjac
Requires(pre): shadow-utils
BuildRequires: coreutils, sed, gnutls-devel >= 2.2.0, tcp_wrappers-devel, libdbi-devel, sqlite, python2-devel
BuildRoot: %{_tmppath}/%{name}-root


%description
Schedwi is a task scheduler.  It can run scripts or commands on remote agents
at a specified date and time and its chaining capability allows tasks to be
run in sequence.  Schedwi is composed of the following components:

* The server schedules the tasks and submits them to the agents.
  The execution of a task can be triggered by date and time but also by the
  result of a previous task or by the existence of a file on a remote agent
  (useful when a task must process a file generated by a previous task).

* The agents receive the task requests from the server and run them on the
  local host.  They report the execution status to the server.

* A command line tool can be used to manage the server, to follow the task
  scheduling in real and to define new tasks.  A Web graphical interface is
  also available.

This package (schedwisrv) is the server part of Schedwi.
It comes as three daemons and must be run on the server.

%package utils
Summary: Text user interface for schedwisrv
Group: Applications/System
Requires: schedwisrv-common
BuildArch: noarch

%description utils
Schedwi is a task scheduler.  It can run scripts or commands on remote agents
at a specified date and time and its chaining capability allows tasks to be
run in sequence.  Schedwi is composed of the following components:

* The server schedules the tasks and submits them to the agents.
  The execution of a task can be triggered by date and time but also by the
  result of a previous task or by the existence of a file on a remote agent
  (useful when a task must process a file generated by a previous task).

* The agents receive the task requests from the server and run them on the
  local host.  They report the execution status to the server.

* A command line tool can be used to manage the server, to follow the task
  scheduling in real and to define new tasks.  A Web graphical interface is
  also available.

This package is the text user interface to administrate Schedwi.  It can be
used to create tasks, and also to follow the task scheduling.

%package common
Summary: Common python modules for schedwisrv
Group: Applications/System
Requires: python, m2crypto, python-sqlalchemy, PyPAM
BuildArch: noarch

%description common
Schedwi is a task scheduler.  It can run scripts or commands on remote agents
at a specified date and time and its chaining capability allows tasks to be
run in sequence.  Schedwi is composed of the following components:

* The server schedules the tasks and submits them to the agents.
  The execution of a task can be triggered by date and time but also by the
  result of a previous task or by the existence of a file on a remote agent
  (useful when a task must process a file generated by a previous task).

* The agents receive the task requests from the server and run them on the
  local host.  They report the execution status to the server.

* A command line tool can be used to manage the server, to follow the task
  scheduling in real and to define new tasks.  A Web graphical interface is
  also available.

This package contains the python modules required by the schedwi web interface
and the command line tools.



%prep
%setup -q


%build
CFLAGS="$RPM_OPT_FLAGS"; export CFLAGS
%ifarch ia64 x86_64 s390x ppc64
LDFLAGS="-L%{_libdir}"; export LDFLAGS
%endif
%configure --with-certdir=/etc/pki/tls/certs --with-keydir=/etc/pki/tls/private
make


%install
rm -rf ${RPM_BUILD_ROOT}
%makeinstall

%find_lang %{name}
%find_lang schedwi

install -d ${RPM_BUILD_ROOT}%{_initddir}
install -m 755 scripts/schedwisrv.redhat ${RPM_BUILD_ROOT}%{_initddir}/schedwisrv
install -m 755 scripts/schedwireg.redhat ${RPM_BUILD_ROOT}%{_initddir}/schedwireg
install -m 755 scripts/schedwigui.redhat ${RPM_BUILD_ROOT}%{_initddir}/schedwigui

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d
install -m 644 scripts/schedwisrv.logrotate ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/schedwisrv

sed -i -e '/#USER=/s/^.*$/USER=schedwi/' \
       -e '/#GROUP=/s/^.*$/GROUP=schedwi/' \
       ${RPM_BUILD_ROOT}/%{_sysconfdir}/schedwisrv.conf
sed -i -e "s,${RPM_BUILD_ROOT},,g" \
       ${RPM_BUILD_ROOT}/%{python_sitelib}/%{name}/config.py 
python -mcompileall ${RPM_BUILD_ROOT}/%{python_sitelib}/%{name}/config.py
python -O -mcompileall ${RPM_BUILD_ROOT}/%{python_sitelib}/%{name}/config.py

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/private
install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/certs
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/private/schedwisrv.key
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/certs/schedwisrv.crt
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/private/schedwisrv-ca.key
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/certs/schedwisrv-ca.crt
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/pki/tls/certs/schedwisrv-ca.crl

%pre
getent group schedwi >/dev/null || groupadd -r schedwi
getent passwd schedwi >/dev/null || \
    useradd -r -g schedwi -d %{_libexecdir}/%{name} -s /sbin/nologin \
    -c "Schedwi server" schedwi
exit 0

%post
/sbin/chkconfig --add schedwisrv
/sbin/chkconfig --add schedwireg
/sbin/chkconfig --add schedwigui

%preun
if [ $1 = 0 ]; then
   service schedwisrv stop >/dev/null 2>&1
   /sbin/chkconfig --del schedwisrv
   service schedwireg stop >/dev/null 2>&1
   /sbin/chkconfig --del schedwireg
   service schedwigui stop >/dev/null 2>&1
   /sbin/chkconfig --del schedwigui
fi


%clean
rm -rf ${RPM_BUILD_ROOT}


%files -f %{name}.lang
%defattr(-,root,root,-)
%doc	COPYING ChangeLog NEWS README*
%doc	doc/schedwi.xml doc/legal.xml doc/COPYING-DOCS doc/schedwi.html doc/*.png
%doc	sql/schedwi_*.sql

%attr(0750,schedwi,schedwi) %dir %{_localstatedir}/log/%{name}
%attr(0755,schedwi,schedwi) %dir %{_localstatedir}/run/%{name}
%attr(0750,schedwi,schedwi) %dir %{_localstatedir}/lib/%{name}
%attr(0750,schedwi,schedwi) %dir %{_localstatedir}/lib/%{name}/crt
%attr(0750,schedwi,schedwi) %dir %{_localstatedir}/lib/%{name}/csr
%attr(0750,schedwi,schedwi) %dir %{_localstatedir}/lib/%{name}/csrpending

%attr(0660,schedwi,schedwi) %config(noreplace) %verify(not md5 size mtime) %{_localstatedir}/lib/%{name}/schedwidb

%config(noreplace) %{_sysconfdir}/schedwisrv.conf
%config(noreplace) %{_sysconfdir}/schedwitemplate.txt
%config(noreplace) %{_sysconfdir}/logrotate.d/schedwisrv
%attr(0600,schedwi,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) /etc/pki/tls/private/schedwisrv.key
%attr(0644,schedwi,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) /etc/pki/tls/certs/schedwisrv.crt
%attr(0600,schedwi,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) /etc/pki/tls/private/schedwisrv-ca.key
%attr(0644,schedwi,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) /etc/pki/tls/certs/schedwisrv-ca.crt
%attr(0644,schedwi,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) /etc/pki/tls/certs/schedwisrv-ca.crl

%{_initddir}/schedwisrv
%{_initddir}/schedwireg
%{_initddir}/schedwigui

%{_bindir}/schedwisrv
%{_bindir}/schedwireg
%{_bindir}/schedwiping
%{_bindir}/schedwica
%{_bindir}/schedwidbchecks
%{_bindir}/schedwigui

%{_libdir}/%{name}

%{_libexecdir}/%{name}

%{_mandir}/man8/*
%{_mandir}/man5/*

%defattr(0644,root,root,0755)
%{python_sitelib}/%{name}/web
%{_datadir}/%{name}


%files common -f schedwi.lang
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/schedwi.conf
%defattr(0644,root,root,0755)
%dir %{python_sitelib}/%{name}
%{python_sitelib}/%{name}/*.py*
%{python_sitelib}/%{name}/cmd_cal
%{python_sitelib}/%{name}/cmd_env
%{python_sitelib}/%{name}/cmd_hosts
%{python_sitelib}/%{name}/cmd_job
%{python_sitelib}/%{name}/cmd_wl
%{python_sitelib}/%{name}/cmd_clusters
%{python_sitelib}/%{name}/tables


%files utils
%defattr(-,root,root,-)
%{_bindir}/schedwi


%changelog
* Wed Aug 14 2013 Herve Quatremain <rv4m@yahoo.co.uk>
- New schedwisrv version (0.1.6)
* Sat Jun 22 2013 Herve Quatremain <rv4m@yahoo.co.uk>
- New schedwisrv version (0.1.5)
* Thu Jan 24 2013 Herve Quatremain <rv4m@yahoo.co.uk>
- New schedwisrv version (0.1.4)
* Mon Sep  6 2010 Herve Quatremain <rv4m@yahoo.co.uk>
- Package creation.
