# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKey
from sqlalchemy.types import Integer

from base import Base


class host_clusters(Base):
    __tablename__ = 'host_clusters'

    cluster_id = Column(Integer, ForeignKey('clusters.id'), primary_key=True)
    host_id = Column(Integer, ForeignKey('hosts.id'), primary_key=True)

    def __init__(self, host_id):
        self.host_id = host_id

    def copy(self):
        return host_clusters(self.host_id)
