# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKey
from sqlalchemy.types import Integer, String, SmallInteger

from base import Base, convert2unicode


class commands(Base):
    __tablename__ = 'commands'

    job_id = Column(Integer, ForeignKey('job_main.id'), primary_key=True)
    username = Column(String(100))
    command_status = Column(SmallInteger)
    command = Column(SmallInteger)
    parameter = Column(SmallInteger)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, job_id, username, command_status, command,
                 parameter, workload_date):
        self.job_id = job_id
        self.username = convert2unicode(username)
        self.command_status = command_status
        self.command = command
        self.parameter = parameter
        self.workload_date = workload_date
